% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster.gaussian.smooth.R
\name{raster.gaussian.smooth}
\alias{raster.gaussian.smooth}
\title{Gaussian smoothing of raster}
\usage{
raster.gaussian.smooth(x, sigma = 2, n = 5, type = mean, ...)
}
\arguments{
\item{x}{A terra SpatRaster raster object}

\item{sigma}{standard deviation (sigma) of kernel (default is 2)}

\item{n}{Size of the focal matrix, single value (default is 
5 for 5x5 window)}

\item{type}{The statistic to use in the smoothing operator 
(suggest mean or sd)}

\item{...}{Additional arguments passed to terra::focal}
}
\value{
A terra SpatRaster class object of the local distributional moment
}
\description{
Applies a Gaussian smoothing kernel to smooth raster.
}
\note{
This is a simple wrapper for the focal function, returning local 
 statistical moments
}
\examples{
\donttest{
library(terra)
r <- rast(nrows=500, ncols=500, xmin=571823, xmax=616763, 
            ymin=4423540, ymax=4453690)
 crs(r) <- "epsg:9001"
r[] <- runif(ncell(r), 1000, 2500)
r <- focal(r, focalMat(r, 150, "Gauss") )

# Calculate Gaussian smoothing with sigma(s) = 1-4
g1 <- raster.gaussian.smooth(r, sigma=1, nc=11)
g2 <- raster.gaussian.smooth(r, sigma=2, nc=11)
g3 <- raster.gaussian.smooth(r, sigma=3, nc=11)
g4 <- raster.gaussian.smooth(r, sigma=4, nc=11)

  opar <- par(no.readonly=TRUE)
  par(mfrow=c(2,2)) 
    plot(g1, main="Gaussian smoothing sigma = 1") 
    plot(g2, main="Gaussian smoothing sigma = 2")
    plot(g3, main="Gaussian smoothing sigma = 3")
    plot(g4, main="Gaussian smoothing sigma = 4")
  par(opar)
}
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
