% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_pairwise.R
\name{all_pairwise}
\alias{all_pairwise}
\title{All pairwise combinations}
\usage{
all_pairwise(x)
}
\arguments{
\item{x}{A numeric or character vector}
}
\value{
A list object with increasing all combination objects,
        the first list element are the pairwise comparisons
}
\description{
Creates all pairwise combinations list for iteration
}
\note{
This returns a list of vector combinations starting with
pairwise, as the first nested list element, then in groups of 
 threes, fours, to length of the vector.
}
\examples{
classes <- paste0("class", 1:10)

all_pairwise(classes)[[1]]

#### How to use as an iterator
# dataframe with 4 cols, 100 rows
d <- as.data.frame(matrix(runif(100*4), 100, 4)) 
  names(d) <- paste0("class", 1:4) 

( idx <- all_pairwise(colnames(d))[[1]] ) 

opar <- par(no.readonly=TRUE)
  par(mfrow=c(2,3))
    lapply(idx, function(i) {
      plot(d[,i[1]], d[,i[2]], main=paste0(i[1], " vs ", i[2]) )
    })	
par(opar)

}
\author{
Jeffrey S. Evans    <jeffrey_evans<at>tnc.org>
}
