% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster.transformations.R
\name{raster.transformation}
\alias{raster.transformation}
\title{Statistical transformation for rasters}
\usage{
raster.transformation(x, trans = "norm", smin = 0, smax = 255)
}
\arguments{
\item{x}{A terra SpatRaster class object}

\item{trans}{Transformation method: "norm", "rstd", "std", "stretch",
"nl", "slog", "sr" (please see notes)}

\item{smin}{Minimum value for stretch}

\item{smax}{Maximum value for stretch}
}
\value{
A terra SpatRaster class object of specified transformation
}
\description{
Transforms raster to a specified statistical transformation

Transformation option details:
\itemize{
\item norm - (Normalization_ (0-1): if min(x) < 0 ( x - min(x) ) / ( max(x) - min(x) )
\item rstd - (Row standardize) (0-1): if min(x) >= 0 x / max(x) This normalizes data
\item 

\if{html}{\out{<div class="sourceCode">}}\preformatted{   with negative distributions
}\if{html}{\out{</div>}}
\item std - (Standardize) (x - mean(x)) / sdv(x)
\item stretch - (Stretch) ((x - min(x)) * max.stretch / (max(x) - min(x)) + min.stretch)
This will stretch values to the specified minimum and maximum values
(eg., 0-255 for 8-bit)
\item nl - (Natural logarithms) if min(x) > 0 log(x)
\item slog - (Signed log 10) (for skewed data): if min(x) >= 0 ifelse(abs(x) <= 1, 0,
sign(x)*log10(abs(x)))
\item sr - (Square-root) if min(x) >= 0 sqrt(x)
}
}
\examples{
\donttest{
library(terra)
r <- rast(nrows=500, ncols=500, xmin=571823, xmax=616763, 
            ymin=4423540, ymax=4453690)
  crs(r) <- "epsg:9001"
r[] <- runif(ncell(r), 1000, 2500)

 # Positive values so, can apply any transformation    
 for( i in c("norm", "rstd", "std", "stretch", "nl", "slog", "sr")) {
   print( raster.transformation(r, trans = i) ) 
 }

 # Negative values so, can't transform using "nl", "slog" or "sr"
 r[] <- runif(ncell(r), -1, 1)
   for( i in c("norm", "rstd", "std", "stretch", "nl", "slog", "sr")) {
  try( print( raster.transformation(r, trans = i) ) ) 
   }
}

}
\author{
Jeffrey S. Evans  \href{mailto:jeffrey_evans@tnc.org}{jeffrey_evans@tnc.org}
}
