% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_interpolation.R
\name{gene_interpolation}
\alias{gene_interpolation}
\title{gene_interpolation: Spatial interpolation of gene expression}
\usage{
gene_interpolation(
  x = NULL,
  genes = "top",
  top_n = 10,
  samples = NULL,
  cores = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{an STlist with transformed RNA counts}

\item{genes}{a vector of gene names or 'top'. If 'top' (default), interpolation of
the 10 genes (\code{top_n} default) with highest standard deviation in each ST sample
is estimated.}

\item{top_n}{an integer indicating how many top genes to perform interpolation.
Default is 10.}

\item{samples}{the spatial samples for which interpolations will be performed.
If NULL (Default), all samples are interpolated.}

\item{cores}{integer indicating the number of cores to use during parallelization.
If NULL, the function uses half of the available cores at a maximum. The parallelization
uses \code{parallel::mclapply} and works only in Unix systems.}

\item{verbose}{either logical or an integer (0, 1, or 2) to increase verbosity.}
}
\value{
x a STlist including spatial interpolations.
}
\description{
Performs spatial interpolation ("kriging") of transformed gene counts
}
\details{
This function takes an STlist and a vector of gene names and generates spatial
interpolation of gene expression values via "kriging". If genes='top', then
the 10 genes (default) with the highest standard deviation for each ST sample
are interpolated. The resulting interpolations can be visualized via the
\code{STplot_interpolation} function
}
\examples{
\donttest{
# Using included melanoma example (Thrane et al.)
# Download example data set from spatialGE_Data
thrane_tmp = tempdir()
unlink(thrane_tmp, recursive=TRUE)
dir.create(thrane_tmp)
lk='https://github.com/FridleyLab/spatialGE_Data/raw/refs/heads/main/melanoma_thrane.zip?download='
tryCatch({ # In case data is not available from network
  download.file(lk, destfile=paste0(thrane_tmp, '/', 'melanoma_thrane.zip'), mode='wb')
  #' zip_tmp = list.files(thrane_tmp, pattern='melanoma_thrane.zip$', full.names=TRUE)
  unzip(zipfile=zip_tmp, exdir=thrane_tmp)
  # Generate the file paths to be passed to the STlist function
  count_files <- list.files(paste0(thrane_tmp, '/melanoma_thrane'),
                            full.names=TRUE, pattern='counts')
  coord_files <- list.files(paste0(thrane_tmp, '/melanoma_thrane'),
                            full.names=TRUE, pattern='mapping')
  clin_file <- list.files(paste0(thrane_tmp, '/melanoma_thrane'),
                          full.names=TRUE, pattern='clinical')
  # Create STlist
  library('spatialGE')
  melanoma <- STlist(rnacounts=count_files,
                     spotcoords=coord_files,
                     samples=clin_file)
  melanoma <- transform_data(melanoma)
  melanoma <- gene_interpolation(melanoma, genes=c('MLANA', 'COL1A1'), samples='ST_mel1_rep2')
  kp = STplot_interpolation(melanoma, genes=c('MLANA', 'COL1A1'))
  ggpubr::ggarrange(plotlist=kp)
}, error = function(e) {
  message("Could not run example. Are you connected to the internet?")
  return(NULL)
})
}

}
