% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gh_grid_search.R, R/highest_concentration.R
\name{neighborhood_gh_search}
\alias{neighborhood_gh_search}
\title{Search for coordinates with higher concentrations within geohash}
\usage{
neighborhood_gh_search(
  hc,
  highest_geohash = 1,
  max.call = 1000,
  verbose = TRUE,
  seed = 1
)

neighborhood_gh_search(
  hc,
  highest_geohash = 1,
  max.call = 1000,
  verbose = TRUE,
  seed = 1
)
}
\arguments{
\item{hc}{object of class `concentration` obtained from `highest_concentration()`}

\item{highest_geohash}{the number of geohashes the searching algorithm is applied to.
Defaults to 1 (i.e. algorithm is only applied to the geohash with the highest concentration).}

\item{max.call}{maximum number of calls to the concentration function
(i.e. the number of coordinates in the neighborhood of the highest concentration). Defaults to 1000.}

\item{verbose}{show messages from the algorithm (TRUE/FALSE). Defaults to FALSE.}

\item{seed}{set seed}
}
\value{
data.frame

data.frame
}
\description{
\code{\link{highest_concentration}} returns the highest concentration within a portfolio based on grid points.
However, higher concentrations can be found within two grid points. `neighborhood_gh_search()`
looks for even higher concentrations in the neighborhood of the grid points with the highest
concentrations. This optimization is done by means of Simulated Annealing.

\code{\link{highest_concentration}} returns the highest concentration within a portfolio based on grid points.
However, higher concentrations can be found within two grid points. `neighborhood_gh_search()`
looks for even higher concentrations in the neighborhood of the grid points with the highest
concentrations. This optimization is done by means of Simulated Annealing.
}
\examples{
\dontrun{
# Find highest concentration with a precision of a grid of 25 meters
hc1 <- highest_concentration(Groningen, amount, radius = 200, grid_distance = 25)

# Increase the number of calls to the concentration function for more extensive search
hc1_nghb <- neighborhood_gh_search(hc1, max.call = 7000, highest_geohash = 1)
hc2_nghb <- neighborhood_gh_search(hc1, max.call = 7000, highest_geohash = 2)
plot(hc1_nghb)
plot(hc2_nghb)
}

\dontrun{
# Find highest concentration with a precision of a grid of 25 meters
hc1 <- highest_concentration(Groningen, amount, radius = 200, grid_distance = 25)

# Increase the number of calls to the concentration function for more extensive search
hc1_nghb <- neighborhood_gh_search(hc1, max.call = 7000, highest_geohash = 1)
hc2_nghb <- neighborhood_gh_search(hc1, max.call = 7000, highest_geohash = 2)
plot(hc1_nghb)
plot(hc2_nghb)
}

}
\author{
Martin Haringa

Martin Haringa
}
