% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task_flowlength.R
\name{raw_flowlength_uniform}
\alias{raw_flowlength_uniform}
\title{Flow length (uniform slope)}
\usage{
raw_flowlength_uniform(mat, slope, cell_size)
}
\arguments{
\item{mat}{The input matrix (must be a logical matrix)}

\item{slope}{The slope of the area documented by the matrix (in degrees).}

\item{cell_size}{The horizontal size of a cell in the matrix (as viewed 
from above).}
}
\value{
A named vector of length 1 containing the flow length numerical 
  value
}
\description{
Compute a simple approximation of the flow length assuming a 
  constant slope
}
\details{
This function computes the Flowlength of a given matrix, using a 
    uniform approximation (the slope is constant across the whole matrix, 
    with maximum slope being from the top of the matrix to its bottom), 
    as per Rodriguez et al. (2017). See \code{\link{flowlength_sews}} for 
    more details.
}
\examples{

\dontrun{ 
raw_flowlength_uniform(arizona[[1]], slope = 20, cell_size = 1)
}


}
\references{
Rodriguez, F., A. G. Mayor, M. Rietkerk, and S. Bautista. 2017. A null model 
  for assessing the cover-independent role of bare soil connectivity as 
  indicator of dryland functioning and dynamics. Ecological Indicators.
}
\seealso{
\code{\link{flowlength_sews}}

\code{\link{indictest}}, to test the significance of indicator values.
}
