\name{spatstat-internal} 
\title{Internal spatstat functions}
\alias{[.pp3}
\alias{[.localpcfmatrix}
\alias{[.splitppx}
\alias{[.diagramobj}
\alias{[<-.splitppx}
\alias{acedist.show}
\alias{acedist.noshow}
\alias{active.interactions}
\alias{adjustthinrange}
\alias{affinexy}
\alias{affinexypolygon}
\alias{anycrossing.psp}
\alias{apply23sum}
\alias{applytolayers}
\alias{Area.xypolygon}       
\alias{areadelta2}       
\alias{areaGain.diri}       
\alias{areaGain.grid}       
\alias{areaLoss.diri}       
\alias{areaLoss.grid}       
\alias{assemble.plot.objects}       
\alias{AsymmDistance.psp}
\alias{as.breakpts}
\alias{as.character.units}
\alias{as.data.frame.bw.optim}
\alias{as.data.frame.fv}
\alias{as.double.im}
\alias{as.im.linim}
\alias{as.list.hyperframe}
\alias{as.listof}
\alias{as.units}
\alias{as2vector}
\alias{asNumericMatrix}
\alias{augment.msr}
\alias{badprobability}
\alias{bbEngine}
\alias{bermantestEngine}
\alias{bdrylength.xypolygon} 
\alias{bdry.mask}
\alias{bind.ratfv}
\alias{blankcoefnames}
\alias{blockdiagmatrix}
\alias{blockdiagarray}
\alias{bounding.box3}
\alias{break.holes}
\alias{breakpts}
\alias{breakpts.from.r}
\alias{bt.frame}
\alias{bw.optim}
\alias{cannot.update}
\alias{cartesian}
\alias{cat.factor}
\alias{cellmiddles}
\alias{censtimeCDFest}
\alias{change.default.expand}          
\alias{checkfields}          
\alias{check.finite}
\alias{check.hist.lengths}
\alias{check.in.range}
\alias{check.named.list}
\alias{check.named.thing}
\alias{check.named.vector}
\alias{check.nvector}
\alias{check.nmatrix}
\alias{check.1.integer}
\alias{check.1.real}
\alias{check.range}
\alias{check.testfun}
\alias{circticks}
\alias{clarkevansCalc}
\alias{clip.psp}
\alias{cliprect.psp}
\alias{clippoly.psp}
\alias{closethresh}
\alias{coef.summary.ppm}
\alias{coef.vblogit} 
\alias{coerce.marks.numeric}
\alias{compatible.rat}
\alias{complaining}
\alias{compileCDF}
\alias{compileK}
\alias{compilepcf}
\alias{conform.ratfv}
\alias{crosspairquad}
\alias{cobble.xy}
\alias{codetime}
\alias{colouroutputs}
\alias{colouroutputs<-}
\alias{commasep}
\alias{conform.imagelist}
\alias{countingweights}
\alias{CressieReadStatistic}
\alias{CressieReadSymbol}
\alias{CressieReadName}
\alias{damaged.ppm}
\alias{data.mppm}
\alias{datagen.runifpointOnLines}
\alias{datagen.runifpoisppOnLines}
\alias{datagen.rpoisppOnLines}
\alias{default.clipwindow}
\alias{default.n.tiling}
\alias{default.ntile}
\alias{deltasuffstat}
\alias{dflt.redraw}
\alias{densitycrossEngine}
\alias{densitypointsEngine}
\alias{diagnose.ppm.engine}
\alias{diagramobj}
\alias{digital.volume}
\alias{dilate.owin}
\alias{dim.fasp}               
\alias{dim.hyperframe}               
\alias{dim.im}               
\alias{dim.msr}
\alias{dim.owin}
\alias{dimnames.fasp}               
\alias{dimnames<-.fasp}
\alias{dimnames.msr}
\alias{distpl}               
\alias{distppl}
\alias{distppll}
\alias{distppllmin}
\alias{distributecbind}
\alias{dist2dpath}
\alias{divisors}
\alias{do.as.im}
\alias{do.call.matched}
\alias{do.call.plotfun}
\alias{do.call.without}
\alias{do.istat}
\alias{doMultiStraussHard}
\alias{dotexpr.to.call}
\alias{dropifsingle}
\alias{dround}
\alias{emptywindow}
\alias{ensure2vector}
\alias{ensure3Darray}
\alias{envelopeEngine}
\alias{envelopeProgressData}
\alias{envelopeTest}
\alias{envelope.matrix}
\alias{equalpairs}          
\alias{equalpairs.quad}          
\alias{equals.quad}          
\alias{equalsfun.quad}          
\alias{eratosthenes}
\alias{erodemask}
\alias{erode.owin}
\alias{evalCovar}
\alias{evalCovar.ppm}
\alias{evalCovar.lppm}
\alias{evalCovariate}
\alias{evalInteraction}
\alias{evalInterEngine}
\alias{evalPairPotential}
\alias{even.breaks.owin}
\alias{evenly.spaced}
\alias{exactdt}              
\alias{exactPdt}
\alias{expand.polynom}
\alias{expandwinPerfect}
\alias{explain.ifnot}
\alias{extractAIC.slrm}
\alias{extractAtomicQtests}
\alias{fakecallstring}
\alias{fakemaintitle}
\alias{family.vblogit} 
\alias{fave.order}
\alias{f3engine}
\alias{f3Cengine}
\alias{fasp}
\alias{findbestlegendpos}
\alias{findCovariate}
\alias{findcbind}
\alias{firstfactor}
\alias{fii}
\alias{fillNA}
\alias{flat.deparse}
\alias{flatfname}
\alias{flipxypolygon}
\alias{fontify}
\alias{forbidNA}
\alias{forbid.logi}
\alias{FormatFaspFormulae}
\alias{fvexprmap}
\alias{fvlabels}
\alias{fvlabels<-}
\alias{fvlabelmap}
\alias{fvlegend}
\alias{g3engine}
\alias{g3Cengine}
\alias{greatest.common.divisor}
\alias{getdataname}
\alias{getdataobjects}
\alias{getfields}
\alias{getglmdata}
\alias{getglmfit}
\alias{getglmsubset}
\alias{getlambda.lpp}
\alias{getlastshift}
\alias{getppmdatasubset}
\alias{getppmOriginalCovariates}
\alias{getSpatstatVariable}
\alias{getSumFun}
\alias{geyercounts}
\alias{geyerdelta2}
\alias{GLMpredict}
\alias{good.names}
\alias{good.correction.K}
\alias{graphicsPars}            
\alias{gridindex}            
\alias{grid1index}
\alias{grow.mask}
\alias{gsubdot}
\alias{HermiteCoefs}
\alias{handle.r.b.args}
\alias{handle.rshift.args}
\alias{hierarchicalordering}
\alias{hiermat}
\alias{ho.engine}
\alias{hsvNA}
\alias{IdenticalRows}
\alias{identical.formulae}
\alias{idorempty}
\alias{ifelseAB}
\alias{ifelseAX}
\alias{ifelseXB}
\alias{ifelseXY}
\alias{ifelse1NA}
\alias{ifelse0NA}
\alias{ifelseNegPos}
\alias{illegal.iformula}
\alias{implemented.for.K}
\alias{impliedpresence}
\alias{impliedcoefficients}
\alias{inject.expr}
\alias{inpoint}
\alias{inside.range}     
\alias{inside.triangle}     
\alias{inside.xypolygon}     
\alias{instantiate.interact}
\alias{intermaker}
\alias{intersect.ranges}     
\alias{intX.owin}     
\alias{intX.xypolygon}     
\alias{intY.owin}     
\alias{intY.xypolygon}
\alias{invokeColourmapRule}
\alias{is.atomicQtest}
\alias{is.cadlag}
\alias{is.data}
\alias{is.expandable}
\alias{is.expandable.ppm}
\alias{is.expandable.rmhmodel}
\alias{is.fv}
\alias{is.hole.xypolygon}
\alias{is.hyperframe}
\alias{is.infline}
\alias{is.interact}
\alias{is.marked.default}    
\alias{is.marked.psp}    
\alias{is.marked.quad}
\alias{is.mppm}
\alias{is.multitype.quad}    
\alias{is.multitype.default}    
\alias{is.parseable}
\alias{is.poisson.mppm}
\alias{is.pp3}
\alias{is.ppx}
\alias{is.prime}
\alias{is.psp}
\alias{is.tess}
\alias{k3engine}
\alias{Kborder.engine}
\alias{Knone.engine}
\alias{Krect.engine}
\alias{Kount}
\alias{Kwtsum}               
\alias{Kpcf.kppm}               
\alias{killinteraction}
\alias{km.rs.opt}
\alias{kppmComLik}
\alias{kppmMinCon}
\alias{kppmPalmLik}
\alias{labels.ppm}
\alias{least.common.multiple}
\alias{levels.im}
\alias{levels<-.im}
\alias{lhs.of.formula}
\alias{linequad}
\alias{linearKengine}
\alias{linearKmulti}
\alias{linearKmulti.inhom}
\alias{linearKmultiEngine}
\alias{linearpcfengine}
\alias{linearpcfmulti}
\alias{linearpcfmulti.inhom}
\alias{linearPCFmultiEngine}
\alias{listof}
\alias{localKengine}
\alias{localpcfengine}
\alias{localpcfmatrix}
\alias{local2lpp}
\alias{logi.dummy}
\alias{logi.engine}
\alias{logLik.vblogit}
\alias{lty2char}
\alias{parbreak}
\alias{passthrough}
\alias{paste.expr}
\alias{plan.legend.layout}
\alias{PoisSaddleApp}
\alias{prettyinside}
\alias{prettydiscrete}
\alias{putSpatstatVariable}
\alias{lookup.im}
\alias{majorminorversion}
\alias{make.even.breaks}
\alias{makefvlabel}
\alias{make.parseable}
\alias{makeunits}
\alias{markappend}
\alias{markcbind}
\alias{markformat}
\alias{markformat.ppp}
\alias{markformat.ppx}
\alias{markformat.psp}
\alias{markformat.default}
\alias{mark.scale.default}
\alias{markspace.integral}
\alias{marks.default}           
\alias{marks.quad}           
\alias{\%mapp\%} %DoNotExport
%NAMESPACE export("%mapp%")
\alias{markappendop}
\alias{marksubset}
\alias{markreplicateop}
\alias{\%mrep\%} %DoNotExport
%NAMESPACE export("%mrep%")
\alias{marksubsetop}
\alias{\%msub\%} %DoNotExport
%NAMESPACE export("%msub%")
\alias{mask2df}
\alias{matcolall}
\alias{matcolany}
\alias{matcolsum}
\alias{matrixsample}
\alias{matrowall}
\alias{matrowany}
\alias{matrowsum}
\alias{maxflow}
\alias{meanlistfv}
\alias{meanX.owin}
\alias{meanY.owin}
\alias{model.se.image}
\alias{mpl.engine}
\alias{mpl.get.covariates}
\alias{mpl.prepare}
\alias{mpl.usable}
\alias{MultiPair.checkmatrix}
\alias{multiply.only.finite.entries}
\alias{multiplicityNumeric}
\alias{na.handle.im}
\alias{names.hyperframe}
\alias{names<-.fv}
\alias{names<-.hyperframe}
\alias{nearest.pixel}
\alias{nearest.valid.pixel}
\alias{newstyle.coeff.handling}
\alias{niceround}
\alias{nncleanEngine}
\alias{nndcumfun}
\alias{no.trend.ppm}
\alias{nobjects}
\alias{nobjects.ppp}
\alias{nobjects.ppx}
\alias{nobjects.psp}
\alias{n.quad}
\alias{numalign}
\alias{numeric.columns}
\alias{nzpaste}
\alias{objsurfEngine}
\alias{offsetsinformula}
\alias{onecolumn}
\alias{optimStatus}
\alias{ordinal}
\alias{\%orifnull\%}  %DoNotExport
%NAMESPACE export("%orifnull%")
\alias{outdated.interact}
\alias{overlap.trapezium}
\alias{overlap.xypolygon}    
\alias{oversize.quad}    
\alias{owinpolycheck}
\alias{owinpoly2mask}
\alias{pairs.listof}
\alias{param.quad}
\alias{paren}
\alias{partialModelMatrix}
\alias{pasteFormula}
\alias{pcf3engine}
\alias{pcfmulti.inhom}
\alias{pickoption}
\alias{plotEachLayer}
\alias{ploterodewin}
\alias{ploterodeimage}
\alias{plot.addvar}
\alias{plot.barplotdata}
\alias{plot.bw.frac}
\alias{plot.bw.optim}
\alias{plot.localpcfmatrix}
\alias{plot.minconfit}
\alias{plot.parres}
\alias{plot.plotpairsim}
\alias{plot.pppmatching}
\alias{plot.profilepl}
\alias{plot.qqppm}
\alias{plot.spatialcdf}
\alias{polynom}
\alias{ppllengine}
\alias{ppm.default}
\alias{ppmCovariates}
\alias{ppmDerivatives}
\alias{ppmInfluence}
\alias{pppdist.mat}
\alias{pppdist.prohorov}
\alias{ppsubset}
\alias{prange}
\alias{predict.vblogit}
\alias{prefixfv}
\alias{prepareTitle}
\alias{primefactors}       
\alias{primesbelow}
\alias{printStatus}
\alias{print.addvar}    
\alias{print.anylist}    
\alias{print.autoexec}    
\alias{print.bt.frame}
\alias{print.bw.frac}
\alias{print.bw.optim}
\alias{print.colourmap}
\alias{print.diagppm}
\alias{print.distfun}
\alias{print.envelope}
\alias{print.ewcdf}
\alias{print.fasp}       
\alias{print.fv}       
\alias{print.fvfun}       
\alias{print.funxy}       
\alias{print.hierarchicalordering}
\alias{print.hyperframe}
\alias{print.influence.ppm}       
\alias{print.interact}       
\alias{print.intermaker}       
\alias{print.isf}
\alias{print.layered}
\alias{print.leverage.ppm}
\alias{print.linim}
\alias{print.localpcfmatrix}
\alias{print.lut}
\alias{print.minconfit}
\alias{print.mppm}
\alias{print.msr}
\alias{print.nnfun}
\alias{print.onearrow}
\alias{print.parres}
\alias{print.plotpairsim}
\alias{print.plotppm}
\alias{print.pppmatching}
\alias{print.profilepl}
\alias{print.quadrattest}
\alias{print.qqppm}
\alias{print.rat}
\alias{print.rmhcontrol}
\alias{print.rmhexpand}
\alias{print.rmhmodel}
\alias{print.rmhstart}
\alias{print.rmhInfoList}
\alias{print.splitppp}
\alias{print.simplepanel}
\alias{print.Smoothfun}       
\alias{print.solist}
\alias{print.splitppx}
\alias{print.summary.hyperframe}
\alias{print.summary.listof}
\alias{print.summary.logiquad}
\alias{print.summary.lut}
\alias{print.summary.mppm}
\alias{print.summary.owin}
\alias{print.summary.ppp}
\alias{print.summary.psp}
\alias{print.summary.rmhexpand}
\alias{print.summary.solist}
\alias{print.summary.splitppp}
\alias{print.summary.splitppx}
\alias{print.summary.units}
\alias{print.symbolmap}       
\alias{print.textstring}
\alias{print.texturemap}
\alias{print.tess}
\alias{print.timed}
\alias{print.vblogit}
\alias{print.yardstick}
\alias{prolongseq}
\alias{putlastshift}
\alias{quad}
\alias{quad.mppm}
\alias{RandomFieldsSafe}
\alias{ratfv}
\alias{recognise.spatstat.type}
\alias{rectquadrat.breaks}
\alias{rectquadrat.countEngine}
\alias{reduceformula}
\alias{repair.image.xycoords}
\alias{resolveEinfo}
\alias{resolve.vargamma.shape}
\alias{rgbNA}
\alias{rhs.of.formula}
\alias{rhohatEngine}
\alias{rhohatCalc}
\alias{RmhExpandRule}
\alias{rmhsnoop}
\alias{roseContinuous}
\alias{ruletextline}
\alias{quadrat.testEngine}
\alias{quadscheme.replicated}
\alias{quadscheme.spatial}
\alias{pointgrid}
\alias{rastersample}
\alias{rasterx.mask}
\alias{rastery.mask}
\alias{rasterxy.mask}
\alias{rasterx.im}
\alias{rastery.im}
\alias{rasterxy.im}
\alias{rebadge.fv}
\alias{rebadge.as.crossfun}
\alias{rebadge.as.dotfun}
\alias{rebound}
\alias{rebound.im}
\alias{rebound.ppp}
\alias{rebound.psp}
\alias{rebound.owin}
\alias{reconcile.fv}
\alias{repair.old.factor.image}
\alias{reincarnate.interact}
\alias{resid4plot}
\alias{resid1plot}
\alias{resid1panel}
\alias{resolve.defaults}
\alias{resolve.1.default}
\alias{resolve.2D.kernel}
\alias{restrict.mask}
\alias{reverse.xypolygon}    
\alias{revcumsum}
\alias{rmax.rule}
\alias{rotxy}
\alias{rotxypolygon}
\alias{row.names.hyperframe}
\alias{row.names<-.hyperframe}
\alias{runifpoispp}          
\alias{runifpoisppOnLines}          
\alias{runifrect}
\alias{rmhResolveControl}
\alias{rmhResolveExpansion}
\alias{rmhResolveTypes}
\alias{rmhSnoopEnv}
\alias{rmhcontrol.rmhcontrol}
\alias{rmhcontrol.list}
\alias{rmhEngine}
\alias{rmhmodel.rmhmodel}
\alias{rmhstart.rmhstart}
\alias{rmhstart.list}
\alias{rmpoint.I.allim}
\alias{rpoint.multi}
\alias{safedeldir}
\alias{safelookup}
\alias{samefunction}
\alias{scalardilate.breakpts}
\alias{scalardilate.msr}
\alias{scanmeasure}
\alias{scanmeasure.ppp}
\alias{scanmeasure.im}
\alias{scanBinomLRTS}
\alias{scanPoisLRTS}
\alias{second.moment.calc}
\alias{second.moment.engine}
\alias{sensiblevarname}
\alias{sewpcf}
\alias{sewsmod}
\alias{shift.diagramobj}              
\alias{shift.influence.ppm}              
\alias{shift.leverage.ppm}              
\alias{shift.msr}              
\alias{shift.quadratcount}              
\alias{shift.quadrattest}              
\alias{shiftxy}              
\alias{shiftxypolygon}              
\alias{short.deparse}
\alias{signalStatus}
\alias{simplenumber}              
\alias{simplify.xypolygon}              
\alias{simulrecipe}              
\alias{singlestring}              
\alias{slr.prepare}
\alias{slrAssemblePixelData}
\alias{smoothcrossEngine}              
\alias{smoothpointsEngine}              
\alias{sort.im}
\alias{spatstat.rawdata.location}
\alias{spatstatClusterModelInfo}
\alias{spatstatRmhInfo}
\alias{spatialCDFframe}
\alias{spatialCDFtest}
%\alias{splat} %DoNotExport
\alias{splitHybridInteraction}
\alias{sp.foundclass}
\alias{sp.foundclasses}
\alias{sphere.volume}
\alias{startinrange}
\alias{store.versionstring.spatstat}
\alias{str.hyperframe}
\alias{strausscounts}
\alias{strsplitretain}
\alias{substringcount}
\alias{suffloc}
\alias{suffstat.generic}
\alias{suffstat.poisson}
\alias{summarise.trend}
\alias{summary.envelope}
\alias{summary.hyperframe}
\alias{summary.logiquad}
\alias{summary.lut}
\alias{summary.mppm}
\alias{summary.profilepl}
\alias{summary.pppmatching}
\alias{summary.ppx}
\alias{summary.splitppx}
\alias{summary.rmhexpand}
\alias{summary.vblogit}
\alias{sumsymouter}
\alias{superimposeMarks}
\alias{symbolmaptype}
\alias{sympoly}
\alias{termsinformula}
\alias{test.crossing.psp}
\alias{test.selfcrossing.psp}
\alias{tilecentroids}        
\alias{tileindex}        
\alias{trap.extra.arguments}
\alias{trianglediameters}
\alias{trim.mask}        
\alias{truncline}        
\alias{tweak.fv.entry}
\alias{unitname.default}
\alias{unitname<-.default}
\alias{unparen}
\alias{update.interact}
\alias{update.im}
\alias{update.ippm}
\alias{update.rmhstart}
\alias{uptrimat}
\alias{validradius}        
\alias{validate.angles}        
\alias{validate.mask}        
\alias{validate.quad}        
\alias{validposint}        
\alias{vanilla.fv}        
\alias{variablesinformula}
%\alias{vblogit} %DoNotExport
%\alias{vblogit.fmla} %DoNotExport
\alias{verbalogic}
\alias{versionstring.interact}
\alias{versionstring.ppm}
\alias{versionstring.spatstat}
\alias{verifyclass}
\alias{verify.xypolygon}
\alias{warn.ignored.args}
\alias{warn.once}
\alias{waxlyrical}
\alias{weighted.var}
\alias{windows.mppm}
\alias{with.msr}
\alias{w.quad}               
\alias{x.quad}
\alias{y.quad}
\alias{xy.grid}
\alias{X2testEngine}
\alias{xtfrm.im}
\alias{xypolygon2psp}
\alias{xypolyselfint}
\description{
  Internal spatstat functions.
}
\usage{
\method{[}{splitppx}(x, \dots)
\method{[}{splitppx}(x, \dots) <- value
\method{[}{diagramobj}(x, \dots)
acedist.show(X, Y, n, d, timelag)
acedist.noshow(X, Y, n, d)
active.interactions(object)
adjustthinrange(ur,vstep,vr)
affinexy(X, mat, vec, invert)
affinexypolygon(p, mat, vec, detmat)
anycrossing.psp(A,B)
apply23sum(x)
applytolayers(L, FUN, \dots)
Area.xypolygon(polly)
areadelta2(X, r, \dots)
areaGain.diri(u, X, r, \dots, W)
areaGain.grid(u, X, r, \dots, W, ngrid)
areaLoss.diri(X, r, \dots, W, subset)
areaLoss.grid(X, r, \dots, W, subset,
                         method = c("count", "distmap"),
                         ngrid = spatstat.options("ngrid.disc"),
                         exact = FALSE)
assemble.plot.objects(xlim, ylim, \dots, lines, polygon)
AsymmDistance.psp(X, Y, metric, method)
as.breakpts(\dots)
\method{as.character}{units}(x, \dots)
\method{as.data.frame}{fv}(x, \dots)
\method{as.data.frame}{bw.optim}(x, \dots)
\method{as.double}{im}(x, \dots)
\method{as.list}{hyperframe}(x, \dots)
\method{as.im}{linim}(X, \dots)
as.listof(x)
as.units(s)
as2vector(x)
asNumericMatrix(x)
augment.msr(x, \dots, sigma)
badprobability(x, NAvalue)
bbEngine(\dots)
bermantestEngine(model, covariate, which, alternative, \dots, modelname, covname, dataname)
bdrylength.xypolygon(polly)
bdry.mask(W)
bind.ratfv(x, numerator, denominator, labl, desc, preferred, ratio)
blankcoefnames(x)
blockdiagmatrix(\dots)
blockdiagarray(\dots)
bounding.box3(\dots)
break.holes(x, splitby, depth, maxdepth)
breakpts(val, maxi, even = FALSE, npos = NULL, step = NULL)
breakpts.from.r(r)
bt.frame(Q, trend, interaction, \dots, covariates,
         correction, rbord, use.gam, allcovar)
bw.optim(cv, h, iopt, \dots, cvname, hname, criterion)
cannot.update(\dots)
cartesian(pp, markset, fac = TRUE)
cat.factor(\dots, recursive=FALSE)
cellmiddles(W, nx, ny, npix, distances)
censtimeCDFest(o, cc, d, breaks, \dots,
     KM, RS, HAN, RAW, han.denom, tt, pmax)
change.default.expand(x, newdefault)
checkfields(X,L)          
check.finite(x, context, xname, fatal, usergiven)
check.hist.lengths(hist,breaks)
check.in.range(x, r, fatal)
check.named.list(x, nam, context, namopt)
check.named.vector(x, nam, context, namopt)
check.named.thing(x, nam, namopt, xtitle, valid, type, context, fatal)
check.nvector(v, npoints, fatal, things, naok, warn)
check.nmatrix(m, npoints, fatal, things, naok, squarematrix, matchto, warn)
check.1.integer(x, context, fatal)
check.1.real(x, context, fatal)
check.range(x, fatal)
check.testfun(f, f1, X)
circticks(R, at)
clarkevansCalc(X, correction, clipregion, working)
clip.psp(x, window, check=TRUE)
cliprect.psp(x, window)
clippoly.psp(s, window)
closethresh(X,R,S,ordered)
\method{coef}{summary.ppm}(object, \dots)
\method{coef}{vblogit}(object, \dots) 
coerce.marks.numeric(X, warn)
\method{compatible}{rat}(A, B, \dots) %DontDeclare
complaining(whinge, fatal, value)
compileCDF(D, B, r, \dots, han.denom, check)
compileK(D, r, weights, denom, check, ratio, fname)
compilepcf(D, r, weights, denom, check, endcorrect, \dots, fname)
conform.ratfv(x)
crosspairquad(Q,rmax,what)
cobble.xy(x, y, f, fatal, \dots)
codetime(x, hms, what)
colouroutputs(x)
colouroutputs(x) <- value
commasep(x, join, flatten)
conform.imagelist(X, Zlist)
countingweights(id, areas, check = TRUE)
CressieReadStatistic(OBS,EXP,lambda)
CressieReadSymbol(lambda)
CressieReadName(lambda)
damaged.ppm(object)
data.mppm(x)
datagen.runifpointOnLines(n, L)
datagen.runifpoisppOnLines(lambda, L)
datagen.rpoisppOnLines(lambda, L, lmax, \dots, check)
default.clipwindow(object, epsilon)
default.n.tiling(X, nd, ntile, npix, eps, random, quasi, verbose)
default.ntile(X)
deltasuffstat(model, \dots, restrict, dataonly, force)
dflt.redraw(button, name, env)
densitycrossEngine(Xdata, Xquery, sigma, \dots,
                    weights, edge, varcov,
                    diggle, sorted)
densitypointsEngine(x, sigma, \dots,
                    weights, edge, varcov,
                    leaveoneout, diggle, sorted, spill)
diagnose.ppm.engine(object, \dots, type, typename, opt,
                         sigma, rbord, compute.sd, compute.cts,
                         envelope, nsim, nrank,
                         rv, oldstyle, splineargs, verbose)
diagramobj(X, \dots)
digital.volume(range, nval, vside)
dilate.owin(\dots)
\method{dim}{fasp}(x)
\method{dim}{hyperframe}(x)
\method{dim}{im}(x)
\method{dim}{msr}(x)
\method{dim}{owin}(x)
\method{dimnames}{fasp}(x)
\method{dimnames}{fasp}(x) <- value
\method{dimnames}{msr}(x)
distpl(p, l)               
distppl(p, l)
distppll(p, l, mintype, method, listit)
distppllmin(p, l, big)
distributecbind(x)
dist2dpath(dist, method="C")
divisors(n)
do.as.im(x, action, \dots, W, eps, dimyx, xy, na.replace)
do.call.matched(fun, arglist, funargs, extrargs, matchfirst, sieve, skipargs)
do.call.plotfun(fun, arglist, \dots)
do.call.without(fun, \dots, avoid)
do.istat(panel)
doMultiStraussHard(iradii, hradii, types)
dotexpr.to.call(expr, dot, evaluator)
dropifsingle(x)
dround(x)
emptywindow(w)
ensure2vector(x)
ensure3Darray(x)
envelopeEngine(X, fun, simul,
           nsim, nrank, \dots, 
           verbose, clipdata, 
           transform, global, ginterval,
           alternative,
           savefuns, savepatterns, saveresultof,
           weights,
           nsim2, VARIANCE, nSD,
           Yname, maxnerr, internal, cl,
           envir.user, expected.arg, do.pwrong)
envelopeProgressData(X, fun, \dots, expo, normalize, deflate)
envelopeTest(X, \dots, power, alternative,
            rinterval, use.theo, tie.rule,
            save.envelope, savefuns, savepatterns,
            Xname, verbose, internal)
\method{envelope}{matrix}(Y, \dots, rvals, observed, theory, funX,
      nsim, nsim2, jsim, jsim.mean,
      type, alternative, csr, use.theory, nrank, ginterval, nSD,
      savefuns, check, Yname, do.pwrong, weights, precomputed)
equalpairs(U, X, marked=FALSE)
equalpairs.quad(Q)
equals.quad(Q)          
equalsfun.quad(Q)          
eratosthenes(nmax, startset)
erodemask(w,r,strict)
erode.owin(\dots)
evalCovar(model, covariate, \dots)
\method{evalCovar}{ppm}(model, covariate, \dots, lambdatype,
          dimyx, eps, jitter, modelname, covname, dataname) 
\method{evalCovar}{lppm}(model, covariate, \dots, lambdatype, 
          eps, nd, jitter, modelname, covname, dataname)
evalCovariate(covariate, locations)
evalInteraction(X,P,E,interaction,correction,\dots,precomputed,savecomputed)
evalInterEngine(X,P,E,interaction,correction,\dots,
                Reach,precomputed,savecomputed)
evalPairPotential(X,P,E,pairpot,potpars,R)
even.breaks.owin(w)
evenly.spaced(x, tol)
exactdt(X, \dots)              
exactPdt(w)
expand.polynom(f)
expandwinPerfect(W, expand, amount)
explain.ifnot(expr, context)
\method{extractAIC}{slrm}(fit, scale = 0, k = 2, \dots)
extractAtomicQtests(x)
fakecallstring(fname, parlist)
fakemaintitle(bb, main, \dots)
\method{family}{vblogit}(object, \dots)
fave.order(x)
f3engine(x, y, z, box, vside, range, nval, correction)
f3Cengine(x, y, z, box, vside, rmax, nrval)
fasp(fns, which, formulae, dataname, title, rowNames, colNames, checkfv)
findbestlegendpos(\dots)
findCovariate(covname, scope, scopename=NULL)
findcbind(root, depth, maxdepth)
firstfactor(x)
fii(interaction, coefs, Vnames, IsOffset)
fillNA(x, value)
flat.deparse(x)
flatfname(x)
flipxypolygon(p)
fontify(x, font)
forbidNA(x, context, xname, fatal, usergiven)
forbid.logi(object)
FormatFaspFormulae(f, argname)
fvexprmap(x)
fvlabels(x, expand=FALSE)
fvlabels(x) <- value
fvlabelmap(x, dot=TRUE)
fvlegend(object, elang)
g3engine(x, y, z, box, rmax, nrval, correction)
g3Cengine(x, y, z, box, rmax, nrval)
greatest.common.divisor(n,m)
getdataname(defaultvalue, \dots, dataname)
getdataobjects(nama, envir, datalist, fatal)
getfields(X, L, fatal = TRUE)
getglmdata(object, drop=FALSE)
getglmfit(object)
getglmsubset(object)
getlambda.lpp(lambda, X, \dots)
getlastshift(X)
getppmdatasubset(object)
getppmOriginalCovariates(object)
getSpatstatVariable(name)
getSumFun(abbreviation, classname, ismarked, fatal)
geyercounts(U,X,r,sat,Xcounts,EqualPairs)
geyerdelta2(X,r,sat)
GLMpredict(fit, data, coefs, changecoef)
good.names(nama, defaults, suffices)
good.correction.K(X)
graphicsPars(key)
gridindex(x, y, xrange, yrange, nx, ny)            
grid1index(x, xrange, nx)
grow.mask(M, xmargin=0, ymargin=xmargin)
gsubdot(replacement, x)
HermiteCoefs(order)
handle.r.b.args(r = NULL, breaks = NULL, window, pixeps = NULL, rmaxdefault)
handle.rshift.args(W, \dots, radius, width, height, edge, clip, edgedefault)
hierarchicalordering(i, s)
hiermat(x, h)
ho.engine(model, \dots, nsim, nrmh, start, control, verb)
hsvNA(h, s, v, \dots)
IdenticalRows(i,j,a,b)
identical.formulae(x,y)
idorempty(w, r, caller)
ifelseAB(test, a, b)
ifelseAX(test, a, x)
ifelseXB(test, x, b)
ifelseXY(test, x, y)
ifelse1NA(test)
ifelse0NA(test)
ifelseNegPos(test, x)
illegal.iformula(ifmla, itags, dfvarnames)
implemented.for.K(correction, windowtype, explicit)
impliedpresence(tags, formula, df, extranames=character(0))
impliedcoefficients(object, tag)
inject.expr(base, expr)
inpoint(W)
inside.range(x, r)
inside.triangle(x, y, xx, yy)
inside.xypolygon(pts, polly, test01, method)
instantiate.interact(x, par)
intermaker(f, blank)
intersect.ranges(a,b,fatal)
intX.owin(w)
intX.xypolygon(polly)
intY.owin(w)
intY.xypolygon(polly)
invokeColourmapRule(colfun, x, \dots, zlim, colargs)
is.atomicQtest(x)
is.cadlag(s)
is.data(Q)
is.expandable(x)
\method{is.expandable}{ppm}(x)  %DontDeclare
\method{is.expandable}{rmhmodel}(x) %DontDeclare
is.fv(x)
is.hole.xypolygon(polly)
is.hyperframe(x)
is.infline(x)
is.interact(x)
\method{is.marked}{default}(\dots)  
\method{is.marked}{psp}(X, \dots)
\method{is.marked}{quad}(X, na.action="warn", \dots)
is.mppm(x)
\method{is.multitype}{default}(X, \dots)  
\method{is.multitype}{quad}(X, na.action="warn", \dots)
is.parseable(x)
\method{is.poisson}{mppm}(x)
is.pp3(x)
is.ppx(x)
is.prime(n)
is.psp(x)
is.tess(x)
k3engine(x, y, z, box, rmax, nrval, correction)
Kborder.engine(X, rmax, nr, correction, weights, ratio)
Knone.engine(X, rmax, nr, weights, ratio)
Krect.engine(X, rmax, nr, correction, weights, ratio, fname)
Kount(dIJ, bI, b, breaks)
Kwtsum(dIJ, bI, wIJ, b, w, breaks)
Kpcf.kppm(model, what)
killinteraction(model)
km.rs.opt(o, cc, d, breaks, KM, RS)
kppmComLik(X, Xname, po, clusters, control, weightfun, rmax, \dots)
kppmMinCon(X, Xname, po, clusters, statistic, statargs, \dots)
kppmPalmLik(X, Xname, po, clusters, control, weightfun, rmax, \dots)
\method{labels}{ppm}(object, \dots)
least.common.multiple(n,m)
\method{levels}{im}(x)
\method{levels}{im}(x) <- value
lhs.of.formula(x)
linequad(X, Y, \dots, eps, nd)
linearKengine(X, \dots, r, reweight, denom, correction, showworking)
linearKmulti(X, I, J, r, \dots, correction)
linearKmulti.inhom(X, I, J, lambdaI, lambdaJ, r, \dots, correction, normalise)
linearpcfengine(X, \dots, r, reweight, denom, correction)
linearpcfmulti(X, I, J, r, \dots, correction)
linearpcfmulti.inhom(X, I, J, lambdaI, lambdaJ, r, \dots,
                     correction, normalise)
linearKmultiEngine(X, I, J, \dots,
                   r, reweight, denom, correction, showworking)
linearPCFmultiEngine(X, I, J, \dots,
                   r, reweight, denom, correction, showworking)
listof(\dots)
localKengine(X, \dots, wantL, lambda, correction, verbose, rvalue)
localpcfengine(X, \dots, delta, rmax, nr, stoyan, lambda)
localpcfmatrix(X, i, \dots, lambda, delta, rmax, nr, stoyan)
local2lpp(L, seg, tp, X)
logi.dummy(X, dummytype, nd, mark.repeat, \dots)
logi.engine(Q, trend, interaction, \dots, 
            covariates, subsetexpr, correction, rbord, covfunargs, allcovar, 
            vnamebase, vnameprefix, justQ, savecomputed, precomputed,
            VB)
\method{logLik}{vblogit}(object, \dots) 
lty2char(i)
parbreak(terse)
passthrough(.Fun, \dots, .Fname)
paste.expr(x)
plan.legend.layout(B, \dots, side, sep, size, sep.frac, size.frac,
                   started, map)
PoisSaddleApp(beta, fi)
prettyinside(x, \dots)
prettydiscrete(x, n)
\method{print}{localpcfmatrix}(x, \dots)
\method{plot}{localpcfmatrix}(x, \dots)
putSpatstatVariable(name, value)
\method{[}{localpcfmatrix}(x, i, \dots)
\method{[}{pp3}(x, i, \dots)
lookup.im(Z, x, y, naok, strict)
majorminorversion(v)
make.even.breaks(bmax, npos, bstep)
makefvlabel(op, accent, fname, sub, argname)
make.parseable(x)
makeunits(sing, plur, mul)
markappend(\dots)
markcbind(\dots)
markformat(x)
\method{markformat}{ppp}(x) %DontDeclare
\method{markformat}{ppx}(x) %DontDeclare
\method{markformat}{psp}(x) %DontDeclare
\method{markformat}{default}(x) %DontDeclare
mark.scale.default(marx, w, markscale, maxsize, meansize, characters)
markspace.integral(X)
\method{marks}{default}(x, \dots)
\method{marks}{quad}(x, dfok=FALSE, \dots)
markappendop(x, y)
x \%mapp\% y
marksubset(x, index, format)
marksubsetop(x, i)
x \%msub\% i
markreplicateop(x, n)
x \%mrep\% n
mask2df(w)
matcolall(x)
matcolany(x)
matcolsum(x)            
matrixsample(mat, newdim, phase, scale, na.value)
matrowall(x)
matrowany(x)
matrowsum(x)
maxflow(costm)
meanlistfv(z, \dots)
meanX.owin(w)            
meanY.owin(w)
model.se.image(fit, W, \dots, what)
mpl.engine(Q, trend, interaction, \dots,
         covariates, subsetexpr, covfunargs, correction,
	 rbord, use.gam, gcontrol, famille,
         forcefit, nd, eps, allcovar, callstring,
         precomputed, savecomputed, preponly,
         rename.intercept, justQ, weightfactor)
mpl.get.covariates(covariates, locations, type, covfunargs, need.deriv)
mpl.prepare(Q, X, P, trend, interaction, covariates, 
            want.trend, want.inter, correction, rbord, Pname,
            callstring, \dots,
            subsetexpr,
            covfunargs, allcovar, precomputed, savecomputed,
            vnamebase, vnameprefix, warn.illegal, warn.unidentifiable,
            weightfactor, skip.border)
mpl.usable(x)
MultiPair.checkmatrix(mat, n, matname, naok, zerook, asymmok)
multiplicityNumeric(x)
multiply.only.finite.entries(x, a)
na.handle.im(X, na.replace)
\method{names}{fv}(x) <- value
\method{names}{hyperframe}(x)
\method{names}{hyperframe}(x) <- value
nearest.pixel(x, y, im)
nearest.valid.pixel(x, y, im)
newstyle.coeff.handling(object)
niceround(x, m)
nncleanEngine(kthNND, k, d, \dots, tol, maxit,
              plothist, lineargs, verbose, Xname)
nndcumfun(X, \dots, r)
no.trend.ppm(x)
nobjects(x)
\method{nobjects}{ppp}(x) %DontDeclare
\method{nobjects}{ppx}(x) %DontDeclare
\method{nobjects}{psp}(x) %DontDeclare
n.quad(Q)
numalign(i, nmax, zero)
numeric.columns(M, logical, others)
nzpaste(\dots, sep, collapse)
objsurfEngine(objfun, optpar, objargs,
              \dots, dotargs, objname,
              ngrid, ratio, verbose)
offsetsinformula(x)
onecolumn(m)
optimStatus(x, call)
printStatus(x, errors.only)
signalStatus(x, errors.only)
ordinal(k)
a \%orifnull\% b
outdated.interact(object)
overlap.trapezium(xa, ya, xb, yb, verb = FALSE)
overlap.xypolygon(P, Q)
oversize.quad(Q, \dots, nU, nX)
owinpolycheck(W, verbose=TRUE)
owinpoly2mask(w, rasta, check=TRUE)
\method{pairs}{listof}(\dots, plot=TRUE)
param.quad(Q)
paren(x, type)
partialModelMatrix(X,D,model,callstring,\dots)
pasteFormula(f)
pcf3engine(x, y, z, box, rmax, nrval, correction, delta)
pcfmulti.inhom(X, I, J, lambdaI = NULL, lambdaJ = NULL, \dots,
               r = NULL, breaks = NULL,
               kernel = "epanechnikov", bw = NULL, stoyan = 0.15,
               correction = c("translate", "Ripley"),
               sigma = NULL, varcov = NULL,
               Iname = "points satisfying condition I",
               Jname = "points satisfying condition J")
pickoption(what="option", key, keymap, \dots,
           exact=FALSE, list.on.err=TRUE, die=TRUE, multi=FALSE)
plotEachLayer(x, \dots, main, plotargs, add, show.all, do.plot)
ploterodewin(W1, W2, col.edge, col.inside, do.plot, \dots)
ploterodeimage(W, Z, \dots, Wcol, rangeZ, colsZ, do.plot)
\method{plot}{addvar}(x, \dots, do.points=FALSE)
\method{plot}{barplotdata}(x, \dots)
\method{plot}{bw.frac}(x, \dots)
\method{plot}{bw.optim}(x, \dots, showopt, optargs)
\method{plot}{minconfit}(x, \dots)
\method{plot}{parres}(x, \dots)
\method{plot}{pppmatching}(x, addmatch = NULL, main = NULL, \dots)
\method{plot}{plotpairsim}(x, \dots)
\method{plot}{profilepl}(x, \dots, add, main, tag, coeff, xvariable,
                         col, lty, lwd, col.opt, lty.opt, lwd.opt)
\method{plot}{qqppm}(x, \dots, limits=TRUE, monochrome=FALSE,
           limcol=if(monochrome) "black" else "red")
\method{plot}{spatialcdf}(x, \dots, xlab, ylab)
polynom(x, \dots)
ppllengine(X, Y, action="project", check=FALSE)
\method{ppm}{default}(Q, trend, interaction,
       \dots, covariates, data, covfunargs, subset, 
       correction, rbord, use.gam, method, forcefit,
       project, nd, eps, gcontrol, nsim, nrmh, start, control,
       verb, callstring)
ppmCovariates(model)
ppmDerivatives(fit, what, Dcovfun, loc, covfunargs)
ppmInfluence(fit, what, \dots, iScore, iHessian, iArgs,
              drop, method, precomputed)
pppdist.mat(X, Y, cutoff = 1, q = 1, matching = TRUE,
            precision = 9, approximation = 10)
pppdist.prohorov(X, Y, n, dfix, type, cutoff, matching,
            ccode, auction, precision, approximation) 
ppsubset(X, I)
prange(x)
\method{predict}{vblogit}(object, newdata, type, se.fit, dispersion,
                          terms, na.action, \dots)
prefixfv(x, tagprefix, descprefix, lablprefix, whichtags)
prepareTitle(main)
primefactors(n, prmax)
primesbelow(nmax)
\method{print}{addvar}(x, \dots)
\method{print}{anylist}(x, \dots)
\method{print}{autoexec}(x, \dots)
\method{print}{bt.frame}(x, \dots)
\method{print}{bw.frac}(x, \dots)
\method{print}{bw.optim}(x, \dots)
\method{print}{colourmap}(x, \dots)
\method{print}{diagppm}(x, \dots)
\method{print}{distfun}(x, \dots)
\method{print}{envelope}(x, \dots)
\method{print}{ewcdf}(x, digits, \dots)
\method{print}{fasp}(x, \dots)
\method{print}{funxy}(x, \dots)
\method{print}{fv}(x, \dots, tight)
\method{print}{fvfun}(x, \dots)
\method{print}{hierarchicalordering}(x, \dots)
\method{print}{hyperframe}(x, \dots)
\method{print}{influence.ppm}(x, \dots)
\method{print}{interact}(x, \dots, family, brief, banner)       
\method{print}{intermaker}(x, \dots)
\method{print}{isf}(x, \dots)
\method{print}{layered}(x, \dots)
\method{print}{leverage.ppm}(x, \dots)
\method{print}{linim}(x, \dots)
\method{print}{lut}(x, \dots)
\method{print}{minconfit}(x, \dots)
\method{print}{mppm}(x, \dots)
\method{print}{msr}(x, \dots)
\method{print}{nnfun}(x, \dots)
\method{print}{onearrow}(x, \dots)
\method{print}{parres}(x, \dots)
\method{print}{plotppm}(x, \dots)
\method{print}{plotpairsim}(x, \dots)
\method{print}{pppmatching}(x, \dots)
\method{print}{profilepl}(x, \dots)
\method{print}{quadrattest}(x, \dots)
\method{print}{qqppm}(x, \dots)
\method{print}{rat}(x, \dots)
\method{print}{rmhcontrol}(x, \dots)
\method{print}{rmhexpand}(x, \dots, prefix=TRUE)
\method{print}{rmhmodel}(x, \dots)
\method{print}{rmhstart}(x, \dots)
\method{print}{rmhInfoList}(x, \dots)
\method{print}{simplepanel}(x, \dots)
\method{print}{Smoothfun}(x, \dots)
\method{print}{solist}(x, \dots)
\method{print}{splitppp}(x, \dots)
\method{print}{splitppx}(x, \dots)
\method{print}{summary.hyperframe}(x, \dots)
\method{print}{summary.listof}(x, \dots)
\method{print}{summary.logiquad}(x, \dots, dp=3)
\method{print}{summary.lut}(x, \dots)
\method{print}{summary.mppm}(x, \dots, brief)
\method{print}{summary.owin}(x, \dots)
\method{print}{summary.ppp}(x, \dots, dp=3)
\method{print}{summary.psp}(x, \dots)
\method{print}{summary.rmhexpand}(x, \dots)
\method{print}{summary.splitppp}(x, \dots)
\method{print}{summary.solist}(x, \dots)
\method{print}{summary.splitppx}(x, \dots)
\method{print}{summary.units}(x, \dots)
\method{print}{symbolmap}(x, \dots)
\method{print}{textstring}(x, \dots)
\method{print}{texturemap}(x, \dots)
\method{print}{tess}(x, \dots, brief=FALSE)
\method{print}{timed}(x, \dots)
\method{print}{vblogit}(x, \dots)
\method{print}{yardstick}(x, \dots)
prolongseq(x, newrange, step)
putlastshift(X, vec)
quad(data, dummy, w, param)
quad.mppm(x)
RandomFieldsSafe()
ratfv(df, numer, denom, \dots, ratio)
recognise.spatstat.type(x)
rectquadrat.breaks(xr, yr, nx = 5, ny = nx, xbreaks = NULL, ybreaks = NULL)
rectquadrat.countEngine(x, y, xbreaks, ybreaks, weights)
reduceformula(fmla, deletevar, verbose)
repair.image.xycoords(x)
resolveEinfo(x, what, fallback, warn)
resolve.vargamma.shape(\dots, nu.ker, nu.pcf)
rgbNA(red, green, blue, \dots)
rhs.of.formula(x, tilde)
rhohatEngine(model, covariate, reference, volume, \dots,
               weights, method, horvitz, smoother, resolution, 
               n, bw, adjust, from, to, 
               bwref, covname, covunits, confidence, modelcall, callstring)
rhohatCalc(ZX, Zvalues, lambda, denom, \dots,
           weights, lambdaX,
           method, horvitz, smoother,
           n, bw, adjust, from, to, 
           bwref, covname, confidence,
           covunits, modelcall, callstring, savestuff)
RmhExpandRule(nama)
rmhsnoop(\dots, Wsim, Wclip, R, xcoords, ycoords, mlevels, mcodes, irep, itype, 
     proptype, proplocn, propmark, propindx, numerator, denominator)
roseContinuous(ang, rad, unit, \dots, main, do.plot)
ruletextline(ch, n, terse)
quadrat.testEngine(X, nx, ny, alternative, method, conditional, CR, 
     \dots, nsim, Xcount, xbreaks, ybreaks, tess, fit, Xname, fitname)
quadscheme.replicated(data, dummy, method = "grid", \dots)
quadscheme.spatial(data, dummy, method = "grid", \dots)
pointgrid(W, ngrid)
rastersample(X, Y)
rasterx.mask(w, drop)
rastery.mask(w, drop)
rasterxy.mask(w, drop)
rasterx.im(x)
rastery.im(x)
rasterxy.im(x, drop)
rebadge.fv(x, new.ylab, new.fname, tags, new.desc, new.labl, new.yexp,
           new.dotnames, new.preferred, new.formula, new.tags)
rebadge.as.crossfun(x, main, sub, i, j)
rebadge.as.dotfun(x, main, sub, i)
rebound(x, rect)
\method{rebound}{im}(x, rect)  %DontDeclare
\method{rebound}{ppp}(x, rect) %DontDeclare
\method{rebound}{psp}(x, rect) %DontDeclare
\method{rebound}{owin}(x, rect) %DontDeclare
reconcile.fv(\dots)
repair.old.factor.image(x)
reincarnate.interact(object)
resid4plot(RES, plot.neg, plot.smooth,
           spacing=0.1, srange=NULL,monochrome=FALSE, main=NULL, \dots)
resid1plot(RES, opt, plot.neg, plot.smooth,
              srange, monochrome, main,
              add, show.all, do.plot, \dots)
resid1panel(observedX, observedV,
            theoreticalX, theoreticalV, theoreticalSD,
            xlab,ylab, \dots, do.plot)
resolve.defaults(\dots, .MatchNull=TRUE, .StripNull=FALSE)
resolve.1.default(.A, \dots)
resolve.2D.kernel(\dots,
            sigma, varcov, x, mindist, adjust, bwfun, allow.zero)
restrict.mask(M, W)
reverse.xypolygon(p, adjust=FALSE)
revcumsum(x)
rmax.rule(fun, W, lambda)
rotxy(X, angle = pi/2)
rotxypolygon(p, angle = pi/2)
rmhResolveControl(control, model)
rmhResolveExpansion(win, control, imagelist, itype)
rmhResolveTypes(model, start, control)
rmhSnoopEnv(Xinit, Wclip, R)
\method{rmhcontrol}{rmhcontrol}(\dots)  %DontDeclare
\method{rmhcontrol}{list}(\dots) %DontDeclare
rmhEngine(InfoList, \dots, verbose, kitchensink, preponly, snoop) 
\method{rmhmodel}{rmhmodel}(model, \dots) %DontDeclare
\method{rmhstart}{rmhstart}(start, \dots) %DontDeclare
\method{rmhstart}{list}(start, \dots) %DontDeclare
rmpoint.I.allim(n, f, types)
\method{row.names}{hyperframe}(x)
\method{row.names}{hyperframe}(x) <- value
rpoint.multi(n, f, fmax, marks, win, giveup, verbose, warn, nsim)
runifpoispp(lambda, win, \dots, nsim)
runifpoisppOnLines(lambda, L, nsim)
runifrect(n, win, nsim)
safedeldir(X)
safelookup(Z, X, factor, warn)
samefunction(f, g)
\method{scalardilate}{breakpts}(X, f, \dots)
\method{scalardilate}{msr}(X, f, \dots)
scanmeasure(X, \dots)
\method{scanmeasure}{ppp}(X, r, \dots, method) %DontDeclare
\method{scanmeasure}{im}(X, r, \dots) %DontDeclare
scanPoisLRTS(nZ, nG, muZ, muG, alternative)
scanBinomLRTS(nZ, nG, muZ, muG, alternative)
second.moment.calc(x, sigma=NULL, edge=TRUE, what="Kmeasure", debug=FALSE,
\dots, varcov=NULL, expand=FALSE)
second.moment.engine(x, sigma, edge, what, \dots,
      obswin, varcov, npts, debug)
sensiblevarname(guess, fallback, maxlen)
sewpcf(d, w, denargs, lambda2area, divisor)
sewsmod(d, ff, wt, Ef, rvals, method="smrep", \dots, nwtsteps=500)
\method{shift}{diagramobj}(X, \dots)
\method{shift}{influence.ppm}(X, \dots)
\method{shift}{leverage.ppm}(X, \dots)
\method{shift}{msr}(X, \dots)
\method{shift}{quadratcount}(X, \dots)
\method{shift}{quadrattest}(X, \dots)
shiftxy(X, vec = c(0, 0))
shiftxypolygon(p, vec = c(0, 0))
short.deparse(x, maxlen)
simplenumber(x, unit, multiply)
simplify.xypolygon(p, dmin)
simulrecipe(type, expr, envir, csr, pois, constraints)
singlestring(s, coll)
slr.prepare(CallInfo, envir, data, dataAtPoints, splitby, clip)
slrAssemblePixelData(Y, Yname, W, covimages, dataAtPoints, pixelarea)
smoothcrossEngine(Xdata, Xquery, values, sigma, \dots,
                    weights, varcov, sorted)
smoothpointsEngine(x, values, sigma, \dots,
                    weights, varcov, leaveoneout, sorted)
\method{sort}{im}(x, \dots)
spatstat.rawdata.location(\dots)
spatstatClusterModelInfo(name)
spatstatRmhInfo(cifname)
spatialCDFframe(model, covariate, \dots)
spatialCDFtest(model, covariate, test, \dots,
         dimyx, eps, jitter, nsim, verbose, modelname, covname, dataname)
sphere.volume(range, nval = 10)
%splat(\dots)
splitHybridInteraction(coeffs, inte)
sp.foundclass(cname, inlist, formalname, argsgiven)             
sp.foundclasses(cnames, inlist, formalname, argsgiven)
startinrange(x0, dx, r)
store.versionstring.spatstat()
\method{str}{hyperframe}(object, \dots)
strausscounts(U,X,r,EqualPairs)
strsplitretain(x, split)
substringcount(x,y)
suffloc(object)
suffstat.generic(model, X, callstring)
suffstat.poisson(model, X, callstring)
summarise.trend(trend, w, a)
\method{summary}{envelope}(object,\dots)
\method{summary}{hyperframe}(object, \dots, brief=FALSE)
\method{summary}{logiquad}(object, \dots, checkdup=FALSE)
\method{summary}{lut}(object, \dots)
\method{summary}{mppm}(object, \dots, brief=FALSE)
\method{summary}{profilepl}(object, \dots)
\method{summary}{pppmatching}(object, \dots)
\method{summary}{ppx}(object, \dots)
\method{summary}{rmhexpand}(object, \dots)
\method{summary}{splitppx}(object, \dots)
\method{summary}{vblogit}(object, \dots)
sumsymouter(x, w)
superimposeMarks(arglist, nobj)
symbolmaptype(x)
sympoly(x, y, n)
termsinformula(x)
test.crossing.psp(A,B)
test.selfcrossing.psp(A)
tilecentroids(W, nx, ny)
tileindex(x, y, Z)
trap.extra.arguments(\dots, .Context, .Fatal)
trianglediameters(iedge, jedge, edgelength, \dots, nvert, check)
trim.mask(M, R, tolerant)
truncline(x, nc)
tweak.fv.entry(x, current.tag, new.labl=NULL, new.desc=NULL, new.tag=NULL)
\method{unitname}{default}(x)  %DontDeclare
\method{unitname}{default}(x) <- value  %DontDeclare
unparen(x)
\method{update}{interact}(object, \dots) 
\method{update}{im}(object, \dots) 
\method{update}{ippm}(object, \dots, envir) 
\method{update}{rmhstart}(object, \dots)
uptrimat(x)
validradius(r, caller)
validate.angles(angles, unit, guess)
validate.mask(w, fatal=TRUE)        
validate.quad(Q, fatal, repair, announce)
validposint(n, caller, fatal)
vanilla.fv(x)
variablesinformula(x)
%vblogit(y, X, offset, eps, m0, S0, S0i, xi0, verb, maxiter, \dots)
%vblogit.fmla(formula, offset, data, subset, weights, verbose, epsilon, \dots)
verbalogic(x, op)
versionstring.interact(object)
versionstring.ppm(object)
versionstring.spatstat()
verifyclass(X, C, N = deparse(substitute(X)), fatal = TRUE)
verify.xypolygon(p, fatal=TRUE)
warn.ignored.args(\dots, context)
warn.once(key, \dots)
waxlyrical(type, terse)
weighted.var(x, w, na.rm)
windows.mppm(x)
\method{with}{msr}(data, expr, \dots)
w.quad(Q)               
x.quad(Q)
y.quad(Q)
xy.grid(xr, yr, nx, ny, dx, dy)
X2testEngine(OBS, EXP, \dots, method, CR, df, nsim,
     conditional, alternative, testname, dataname)
\method{xtfrm}{im}(x)
xypolyselfint(p, eps, proper, yesorno, checkinternal)
xypolygon2psp(p, w, check)
}
\details{
  These internal \pkg{spatstat} functions are not usually called
  directly by the user. Their names and capabilities may change
  without warning from one version of \pkg{spatstat} to the next.
}
\keyword{internal}
