% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingfunctions.R
\name{spplot_compare}
\alias{spplot_compare}
\title{spplot_compare function}
\usage{
spplot_compare(x, y, what, what1 = what, palette = brewer.pal(9,
  "Oranges"), legpos = "topleft", border = NA, fun = identity,
  t1 = "", t2 = "", bw = FALSE, ...)
}
\arguments{
\item{x}{a SpatialPolgonsDataFrame or a SpatialPointsDataFrame}

\item{y}{a SpatialPolgonsDataFrame or a SpatialPointsDataFrame}

\item{what}{the name of the variable from x to plot}

\item{what1}{the name of the variable from y to plot. default is to plot the variable of the same name}

\item{palette}{the palette, can either be a vector of names of colours, or a vector of colours produced for example by the brewer.pal function.}

\item{legpos}{the position of the legend, options are 'topleft', 'topright', 'bottomleft', 'bottomright'}

\item{border}{see ?spplot}

\item{fun}{an optional function of the data to plot, default is the identity function}

\item{t1}{title for the plot of x}

\item{t2}{title for the plot of y}

\item{bw}{Logical. Plot in black/white/greyscale? Default is to produce a colour plot. Useful for producing plots for journals that do not accept colour plots.}

\item{...}{other arguments to be passed to the plot function}
}
\value{
produces a plot comparing x[[what]] and y[[what1]]
}
\description{
A function to compare two SpatialPolgonsDataFrame or SpatialPointsDataFrame objects using a unified legend for the variable
of interest in both
}
