% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEPRECATED-set-defaults.R
\name{set_default_level_occurrence}
\alias{set_default_level_occurrence}
\title{Sets the default level occurrence in an attribute level balanced design}
\usage{
set_default_level_occurrence(n_lvls, rows)
}
\arguments{
\item{n_lvls}{An integer giving the number of levels for the considered
attribute}

\item{rows}{Number of rows in the design}
}
\value{
A named list of lists where the top level gives the attribute and the
lower level gives the times or range each attribute level should occur in
the design
}
\description{
The function sets the default level occurrence of an attribute when a design
is restricted to be attribute level balanced. If the design cannot be
attribute level balanced, then the restriction will be relaxed for each
attribute failing to meet this criteria. Specifically, the code will impose
a minimum range of how often an attribute level can occur. This will secure
that the design is near attribute level balanced. In this case a warning is
issued.
}
