% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relevant.features.p.R
\name{relevant.features.p}
\alias{relevant.features.p}
\title{identify features (columns in the datamatrix) which are significantly associated with the outcome vector}
\usage{
relevant.features.p(datamatrix, responsevector, p.adj = "BH")
}
\arguments{
\item{datamatrix}{the data matrix with a column for each feature.}

\item{responsevector}{the vector of outcomes/responses (e.g. class labels). the length of this vector should match the amount of rows in datamatrix.}

\item{p.adj}{the adjustment method for the p-values. Any of 'holm', 'hochberg', 'hommel', 'bonferroni', 'BH' (default), 'BY', 'fdr' or 'none' are accepted.}
}
\value{
data with the features and their (adjusted) p-values, one for every column in the datamatrix  .
}
\description{
This function produces a p-value for every column in the datamatrix, corresponding to the null hypothesis that outcome/responsevector is independent of that feature.
}
\examples{
nSamples <- 10
nFeatures <- 20
data.matrix <- matrix( stats::runif(n=nFeatures*nSamples, min=0,max=100), 
ncol = nFeatures, nrow = nSamples)

response <- c( rep(0,nSamples/2), rep(1,nSamples/2) )
p_values <- relevant.features.p(datamatrix = data.matrix, responsevector = 
response, p.adj = 'none')
p_values_adjusted <- relevant.features.p( datamatrix = data.matrix, 
responsevector = response, p.adj = 'bonferroni')

}
\author{
Charlie Beirnaert, \email{charlie.beirnaert@uantwerpen.be}
}
