% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plotVars}
\alias{plotVars}
\title{Plots the variables in each model.}
\usage{
plotVars(sca_data, title = "", colorControls = FALSE)
}
\arguments{
\item{sca_data}{A data frame returned by `sca()` containing model estimates
from the specification curve analysis.}

\item{title}{A string to use as the plot title. Defaults to an empty string,
`""`.}

\item{colorControls}{A boolean indicating whether to give each variable a
color to improve readability. Defaults to `FALSE`.}
}
\value{
A ggplot object.
}
\description{
plotVars() plots the variables included in each model specification in order
of model index. Returns a ggplot object that can then be combined with the
output of other functions like plotRMSE() if further customization of each
plot is desired.
}
\examples{
plotVars(sca_data = sca(y = "Salnty", x = "T_degC",
                        controls = c("ChlorA", "O2Sat"),
                        data = bottles, progressBar = TRUE,
                        parallel = FALSE),
                     title = "Model Variable Specifications");
plotVars(sca_data = sca(y = "Salnty", x = "T_degC",
                        controls = c("ChlorA*O2Sat"),
                        data = bottles, progressBar = FALSE,
                        parallel = FALSE),
                     colorControls = TRUE);
plotVars(sca_data = sca(y = "Salnty", x = "T_degC",
                        controls = c("ChlorA*NO3uM", "O2Sat*NO3uM"),
                        data = bottles,
                        progressBar = TRUE, parallel = TRUE, workers = 2));
}
