% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thresholdopt.R
\name{search_threshold}
\alias{search_threshold}
\title{Determine the threshold using Locally estimated or weighted Scatterplot Smoothing.}
\usage{
search_threshold(
  data,
  outliers,
  sp = NULL,
  plotsetting = list(plot = FALSE, group = NULL),
  var_col = NULL,
  warn = FALSE,
  verbose = FALSE,
  cutoff,
  tloss = seq(0.1, 1, 0.1)
)
}
\arguments{
\item{data}{\code{Dataframe}. The reference dataframe were absolute outliers will be removed.}

\item{outliers}{\code{datacleaner}. Datacleaner output with outliers flagged in \code{multidetect} function.}

\item{sp}{\code{string}. Species name or index if multiple species are
considered during outlier detection.}

\item{plotsetting}{\code{list}. to show plot of loess fitted function with local and global maxima (optimal threshold and clean data).
The list had two parameters. 1) plot to indicate the plot and group to provide the plot title.}

\item{var_col}{\code{string}. A column with species names if \code{dataset} for species is a dataframe not a list.
See \code{\link{pred_extract}} for extracting environmental data.}

\item{warn}{\code{logical}. If \strong{TRUE}, warning on whether absolute
outliers obtained at a low threshold is indicated. Default \strong{TRUE}.}

\item{verbose}{\code{logical}. If true, then messages about the outlier flagging will be displayed.}

\item{cutoff}{\code{numeric}. Ranging from 0.5 to 0.8 indicating the cutoff to initiate the
LOESS model to optimize the identification of absolute outliers.}

\item{tloss}{\code{seqences} Indicates the sequence for tuning the the span parameter of the LOESS model.}
}
\value{
Returns \code{numeric} of most suitable threshold at globalmaxima or localmaxima of the loess smoothing.
}
\description{
Determine the threshold using Locally estimated or weighted Scatterplot Smoothing.
}
