% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-methods.R, R/setters.R
\docType{methods}
\name{wl}
\alias{wl}
\alias{wl<-}
\alias{wl,Spectra-method}
\alias{wl<-,Spectra-method}
\alias{wl<-,data.frame-method}
\alias{wl<-,data.frame-method}
\alias{wl<-,Spectra-method}
\title{Retrieves or sets the wavelengths of a \code{Spectra*} object.}
\usage{
\S4method{wl}{Spectra}(object)

\S4method{wl}{data.frame}(object) <- value

\S4method{wl}{Spectra}(object) <- value
}
\arguments{
\item{object}{a \code{"data.frame"} or an object inheriting from class
\code{Spectra}}

\item{value}{the wavelengths of the \code{Spectra*} object to create}
}
\value{
If applied on a \code{"data.frame"}, either a \code{Spectra} or a
\code{SpectraDataFrame} object. If applied on a \code{Spectra*} object, a
vector.
}
\description{
Either retrieves the wavelengths from a \code{Spectra*} object, or creates a
\code{Spectra*} object from a \code{"data.frame"} object by setting some of
its columns as the wavelengths.

When applied to a \code{Spectra*} object, this functions simply returns the
wavelengths of the spectra it is storing.

If applied on a \code{"data.frame"} object, it is an helper function to
create a \code{Spectra*} object. It then needs to be indicated the
wavelengths at which the spectra values are measured. The assumption is that
each row of the \code{"data.frame"} is a spectra, and the column names of
the \code{"data.frame"} contain the wavelengths values.

If all the columns are used to create the \code{Spectra*} object, a
\code{Spectra} object is created. If some attributes are left, they will be
used to generate a \code{SpectraDataFrame} object.
}
\examples{

# Loading example data
data(oz)
spectra(oz) <- sr_no ~ ... ~ 350:2500

# Retrieving wavelengths from Spectra* object
wl(oz)

# Replacing wavelength values - USE WITH CAUTION!
wl(oz) <- 1:length(oz)
wl(oz)

# Use to initiate a Spectra* object from a data.frame
data(oz)
wl(oz) <- 350:2500
ids(oz) <- ~ sr_no

}
\seealso{
\code{spectra}, \code{Spectra-class},
\code{SpectraDataFrame-class}
}
\author{
Pierre Roudier \email{pierre.roudier@gmail.com}
}
