% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specLOMB.R
\name{spec.lomb}
\alias{spec.lomb}
\title{Lomb-Scargle Periodigram}
\usage{
spec.lomb(y = stop("Missing y-Value"), x = stop("Missing x-Value"),
  f = NULL, ofac = 4)
}
\arguments{
\item{y}{data vector}

\item{x}{sampling vector}

\item{f}{frequeny vector}

\item{ofac}{in case \code{f=NULL} this value controlls the amount of frequency
oversampling.}
}
\value{
The \code{spec.lomb} function returns an object of the type \code{lomb},
which is a \code{list} containg the following parameters:
\describe{
 \item{\code{A}}{A vector with amplitude spectrum}
 \item{\code{f}}{corresponding frequency vector}
 \item{\code{phi}}{phase vector}
 \item{\code{x,y}}{original data}
 \item{p}{p-value as statistical measure}
}
}
\description{
The Lomb-Scargle periodigram represents an
statistical estimator for the amplitude and
phase for a given frequency.
}
\details{
A given time series does not need to be evenly sampled. This means a time series mainly
consists of data pairs \code{x} and \code{y}, which store the data and the sampling
position (e.g. in time). Additionally, this method enables the user to analyse
the data with respect to a given frequency vector, which can be artifical dense.
\describe{
 \item{\code{ofac}}{If the user does not provide a corresponding frequency vector, the
 \code{ofac} parameter causes the function to estimate \deqn{nf = ofac*length(x)/2}
 equidistant frequencies.}
 \item{\code{p}-value}{The \code{p}-value gives the probability, wheater the
 estimated amplitude is NOT significant. However, if \code{p} tends to zero the
 amplidutde is significant. The user must decide which maximum value is acceptable,
 until an amplitude is not valid.}
}
}
\examples{
# create two sin-functions
x_orig <- seq(0,1,by=1e-2)
y_orig <- sin(10*2*pi*x_orig) + 0.3*sin(2*2*pi*x_orig)

# make a 10\% gap
i <- round(length(x_orig)*0.2) : round(length(x_orig)*0.3)
x <- x_orig
y <- y_orig
x[i] <- NA
y[i] <- NA

# calculating the lomb periodogram
l <- spec.lomb(x = x, y = y)
# select a frequency range
m <- rbind(c(9,11))
# select and reconstruct the most significant component
l2 = filter.lomb(l, x_orig, filt=m)

# plot everything
par(mfrow=c(2,1),mar = c(4,4,2,4))
plot(x,y,"l", main = "Gapped signal")
lines(l2$x, l2$y,lty=2)
legend("bottomleft",c("gapped","10Hz component"),lty=c(1,2))

plot(l,main = "Spectrum")

}
\references{
A. Mathias, F. Grond, R. Guardans, D. Seese, M. Canela, H. H. Diebner, und G. Baiocchi,
"Algorithms for spectral analysis of irregularly sampled time series",
Journal of Statistical Software, 11(2), pp. 1--30, 2004.

J. D. Scargle, "Studies in astronomical time series analysis. II - Statistical
 aspects of spectral analysis of unevenly spaced data", The Astrophysical Journal,
 263, pp. 835--853, 1982.
}
\seealso{
\code{\link{filter.lomb}}
}

