% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectralPreprocessing.R
\name{localBaselineCorrect}
\alias{localBaselineCorrect}
\title{local baseline correct, substract a baseline either trough 1 or 2 points}
\usage{
localBaselineCorrect(object, baseWavelengths = NULL)
}
\arguments{
\item{object}{\code{\link{SpectraInTime-class}}}

\item{baseWavelengths}{numeric vector of 1 or 2 wavelength use to draw a baseline trough,
defaults to \code{NULL} when no baseline correction is performed}
}
\value{
\code{\link{SpectraInTime-class}} with baseline subset
}
\description{
local baseline correct, substract a baseline either trough 1 or 2 points
}
\examples{
spectra              <-  getSpectraInTimeExample()
spectraConstCorrect  <-  localBaselineCorrect( spectra , baseWavelengths = 240  )
spectraLinCorrect    <-  localBaselineCorrect( spectra , c( 250 , 330 )  ) 
\dontrun{
plot( spectra )
plot( spectraConstCorrect )
plot( spectraLinCorrect ) 
}
}
\author{
Adriaan Blommaert
}
