% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectralNMF.R
\name{runNMF}
\alias{runNMF}
\title{Actual NMF analysis}
\usage{
runNMF(
  spectra,
  rank,
  method = "PGNMF",
  seed = NULL,
  nruns = 10,
  checkDivergence = TRUE,
  timePointsList = NULL,
  subsamplingFactor = 3,
  maxIter = 1000
)
}
\arguments{
\item{spectra}{spectral input matrix, with wavelengths as its rows and time points as its columns}

\item{rank}{number of NMF components to be found}

\item{method}{name of the NMF method to be used, consult the help
of the 'nmf' function from the NMF package for the methods available by default}

\item{seed}{nmfModel object containing initialization of the factor matrices}

\item{nruns}{number of NMF runs. It is recommended to run the NMF analyses multiple
times when random seeding is used, to avoid a suboptimal solution}

\item{checkDivergence}{Boolean indicating whether divergence checking should be performed, defaults to \code{TRUE}}

\item{timePointsList}{list of time point vectors of the individual experiments}

\item{subsamplingFactor}{subsampling factor used during NMF analysis}

\item{maxIter}{maximum number of iterations per NMF run}
}
\value{
Resulting NMF model (in accordance with the NMF package definition)
}
\description{
Actual NMF analysis
}
\author{
Nicolas Sauwen
}
