% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_function_overloads.R
\name{sd.default}
\alias{sd.default}
\title{Default variance}
\usage{
\method{sd}{default}(x, na.rm = FALSE)
}
\arguments{
\item{x}{a numeric vector or an \R object which is coercible to one
    by \code{as.double(x)}.}

\item{na.rm}{logical.  Should missing values be removed?}
}
\description{
Default variance
}
\details{
Like \code{\link{var}} this uses denominator \eqn{n - 1}.

  The standard deviation of a zero-length vector (after removal of
  \code{NA}s if \code{na.rm = TRUE}) is not defined and gives an error.
  The standard deviation of a length-one vector is \code{NA}.
}
\seealso{
\code{\link{var}} for its square, and \code{\link{mad}}, the most
  robust alternative.
}
