/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.speedr.importwizard.steps;

import at.ac.ait.speedr.table.RDate;
import at.ac.ait.speedr.table.RPOSIXct;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportTableModel
extends AbstractTableModel {
    private TreeMap<Integer, Object[]> allData;
    private HashMap<Integer, Class> classes;
    private HashMap<Integer, Integer> columnMismatchCounter;
    private static final int MAXMISMATCH = 5;
    private boolean hasColnames = false;
    private int colnamesRowIndex = 0;
    private boolean hasRownames = false;
    private int rownamesColumnIndex = 0;
    private int maxColumnCount = 0;
    private int rowStart = 0;
    private int rowEnd = 0;
    private int colStart = 0;
    private int colEnd = 0;
    private boolean addingRow = false;
    private boolean clearing = false;
    private boolean fireTableStructureChangedCalled = false;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public ImportTableModel() {
        this.allData = new TreeMap();
        this.classes = new HashMap();
        this.columnMismatchCounter = new HashMap();
    }

    @Override
    public int getRowCount() {
        if (this.allData.size() == 0) {
            return 0;
        }
        return this.rowEnd - this.rowStart + 1;
    }

    public int getRealRowIndex(int rowIndex) {
        return this.rowStart + rowIndex;
    }

    public int getMaxRowCount() {
        return this.allData.size();
    }

    @Override
    public String getColumnName(int column) {
        if (this.hasRownames && column == 0) {
            return "row.names";
        }
        if (this.hasColnames) {
            int colIndex = this.getRealColumnIndex(column);
            if (this.hasRownames && this.rownamesColumnIndex == 0 && this.allData.get(this.colnamesRowIndex).length + 1 == this.maxColumnCount) {
                --colIndex;
            }
            if (colIndex < this.allData.get(this.colnamesRowIndex).length) {
                return this.allData.get(this.colnamesRowIndex)[colIndex].toString();
            }
            return super.getColumnName(column);
        }
        return super.getColumnName(column);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.hasRownames && columnIndex == 0) {
            return String.class;
        }
        return this.classes.get(this.getRealColumnIndex(columnIndex));
    }

    private boolean checkAllColumnClasses() {
        boolean returnval = false;
        for (int columnIndex = 0; columnIndex < this.getColumnCount(); ++columnIndex) {
            boolean flag = true;
            if (this.columnMismatchCounter.get(this.getRealColumnIndex(columnIndex)) >= 5) continue;
            for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
                if (!(this.getValueAt(rowIndex, columnIndex) instanceof String)) continue;
                flag = false;
                if (this.classes.get(this.getRealColumnIndex(columnIndex)) != Double.class) break;
                this.classes.put(this.getRealColumnIndex(columnIndex), String.class);
                returnval = true;
                break;
            }
            if (!flag) continue;
            returnval = true;
            this.classes.put(this.getRealColumnIndex(columnIndex), Double.class);
        }
        return returnval;
    }

    private boolean checkColumnClass(int columnIndex) {
        if (this.columnMismatchCounter.get(this.getRealColumnIndex(columnIndex)) >= 5) {
            return false;
        }
        boolean flag = true;
        for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
            if (!(this.getValueAt(rowIndex, columnIndex) instanceof String)) continue;
            flag = false;
            break;
        }
        if (flag) {
            this.classes.put(this.getRealColumnIndex(columnIndex), Double.class);
        } else {
            this.classes.put(this.getRealColumnIndex(columnIndex), String.class);
        }
        return flag;
    }

    @Override
    public int getColumnCount() {
        if (this.maxColumnCount == 0) {
            return 0;
        }
        if (this.hasRownames) {
            assert (this.colEnd - this.colStart + 2 <= this.maxColumnCount) : "colEnd: " + this.colEnd + " colStart: " + this.colStart;
            return this.colEnd - this.colStart + 2;
        }
        assert (this.colEnd - this.colStart + 1 <= this.maxColumnCount) : "getColumnCount() returns greater than maxcolumncount";
        return this.colEnd - this.colStart + 1;
    }

    private int getRealColumnIndex(int columnIndex) {
        if (this.hasRownames && columnIndex == 0) {
            return this.rownamesColumnIndex;
        }
        int realColIndex = this.colStart + columnIndex;
        if (this.hasRownames && realColIndex <= this.rownamesColumnIndex) {
            --realColIndex;
        }
        assert (realColIndex >= 0) : "realColIndex: " + realColIndex + " columnIndex: " + columnIndex;
        assert (realColIndex < this.maxColumnCount || this.getColumnCount() == 0) : "realColIndex is out ouf bound.\n realColIndex: " + realColIndex + " and column count: " + this.getColumnCount() + " columnIndex: " + columnIndex;
        return realColIndex;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.ensureRowArrayLength(rowIndex, columnIndex);
        Object oldValue = this.getValueAt(rowIndex, columnIndex);
        this.allData.get((Object)Integer.valueOf((int)this.getRealRowIndex((int)rowIndex)))[this.getRealColumnIndex((int)columnIndex)] = aValue;
        if (oldValue != null && aValue != null) {
            if (!oldValue.equals(aValue)) {
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        } else if (oldValue != null || aValue != null) {
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    private void ensureRowArrayLength(int rowIndex, int columnIndex) {
        int realRowIndex = this.getRealRowIndex(rowIndex);
        int realColumnIndex = this.getRealColumnIndex(columnIndex);
        if (realColumnIndex >= this.allData.get(realRowIndex).length) {
            Object[] oldrow = this.allData.get(realRowIndex);
            Object[] newrow = new Object[realColumnIndex + 1];
            System.arraycopy(oldrow, 0, newrow, 0, oldrow.length);
            this.allData.put(realRowIndex, newrow);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.allData.size() == 0) {
            return null;
        }
        rowIndex = this.getRealRowIndex(rowIndex);
        if ((columnIndex = this.getRealColumnIndex(columnIndex)) < this.allData.get(rowIndex).length) {
            return this.allData.get(rowIndex)[columnIndex];
        }
        return null;
    }

    public void addRow(List<String[]> rowData) {
        this.addingRow = true;
        int index = this.allData.size();
        boolean colendchanged = false;
        for (String[] row : rowData) {
            Object[] newRow = this.convertRowAndSetColumnClasses(row);
            this.allData.put(index++, newRow);
            if (this.maxColumnCount >= row.length) continue;
            this.maxColumnCount = row.length;
            colendchanged = true;
        }
        if (colendchanged) {
            this.setColEnd(this.maxColumnCount - 1);
        }
        this.setRowEnd(this.allData.size() - 1);
        this.addingRow = false;
    }

    public void addRows(List<String[]> rowData) {
        this.addingRow = true;
        int index = this.allData.size();
        for (String[] row : rowData) {
            for (int i = 0; i < row.length; ++i) {
                row[i] = StringUtils.trimToNull((String)row[i]);
                if (this.classes.containsKey(i)) continue;
                this.classes.put(i, String.class);
                this.columnMismatchCounter.put(i, 0);
            }
            Object[] newRow = new Object[row.length];
            System.arraycopy(row, 0, newRow, 0, row.length);
            this.allData.put(index++, newRow);
            if (this.maxColumnCount >= row.length) continue;
            this.maxColumnCount = row.length;
            this.setColEnd(this.maxColumnCount - 1);
        }
        this.setRowEnd(this.allData.size() - 1);
        this.addingRow = false;
    }

    public void convertColumnsToNumericIfPossible() {
        boolean fireTableStructureChanged = false;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (i == 0 && this.hasRownames) continue;
            try {
                this.checkNumeric(i);
                this.convertToNumeric(i, false, false);
                fireTableStructureChanged = true;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (fireTableStructureChanged) {
            this.fireTableStructureChanged();
        }
    }

    private Object[] convertRowAndSetColumnClasses(String[] row) {
        boolean flag = false;
        Object[] newRow = new Object[row.length];
        for (int i = 0; i < row.length; ++i) {
            int mismatchcount;
            if (!this.classes.containsKey(i)) {
                this.classes.put(i, Double.class);
                this.columnMismatchCounter.put(i, 0);
            }
            if ((mismatchcount = this.columnMismatchCounter.get(i).intValue()) < 5) {
                if (StringUtils.stripToNull((String)row[i]) == null || row[i].trim().equalsIgnoreCase("NA") || row[i].trim().equalsIgnoreCase("NaN")) {
                    newRow[i] = null;
                    continue;
                }
                if (NumberUtils.isNumber((String)row[i])) {
                    Double d = NumberUtils.createDouble((String)row[i]);
                    newRow[i] = d;
                    continue;
                }
                this.columnMismatchCounter.put(i, ++mismatchcount);
                this.classes.put(i, String.class);
                newRow[i] = row[i];
                if (this.allData.isEmpty() || this.classes.get(i) == String.class) continue;
                flag = true;
                continue;
            }
            newRow[i] = StringUtils.stripToNull((String)row[i]);
        }
        if (flag) {
            this.fireTableStructureChanged();
        }
        return newRow;
    }

    public boolean hasColumnNames() {
        return this.hasColnames;
    }

    public void setHasColumnNames(boolean hasColnames) {
        this.fireTableStructureChangedCalled = false;
        if (this.hasColnames != hasColnames) {
            boolean oldValue = this.hasColnames;
            this.hasColnames = hasColnames;
            if (!this.clearing) {
                if (hasColnames && this.rowStart <= this.colnamesRowIndex) {
                    this.setRowStart(this.colnamesRowIndex + 1);
                }
                this.fireTableStructureChanged();
            }
            this.propertyChangeSupport.firePropertyChange(PROP.HASCOLUMNNAMES.name(), oldValue, this.hasColnames);
        }
        this.fireTableStructureChangedCalled = false;
    }

    public void setColumnNamesRowIndex(int colnamesRowIndex) {
        if (this.colnamesRowIndex != colnamesRowIndex) {
            int oldValue = this.colnamesRowIndex;
            this.colnamesRowIndex = colnamesRowIndex;
            if (this.hasColnames && this.rowStart <= this.colnamesRowIndex) {
                this.setRowStart(this.colnamesRowIndex + 1);
            }
            this.fireTableStructureChanged();
            this.propertyChangeSupport.firePropertyChange(PROP.COLUMNNAMESROWINDEX.name(), oldValue, this.colnamesRowIndex);
        }
    }

    public int getColumnNamesRowIndex() {
        return this.colnamesRowIndex;
    }

    public boolean hasRowNames() {
        return this.hasRownames;
    }

    public void setHasRowNames(boolean hasRownames) {
        if (this.hasRownames != hasRownames && this.maxColumnCount > 1) {
            boolean oldValue = this.hasRownames;
            this.hasRownames = hasRownames;
            if (this.hasRownames) {
                this.setColEnd(this.colEnd - 1);
            } else {
                this.setColEnd(this.colEnd + 1);
            }
            this.propertyChangeSupport.firePropertyChange(PROP.HASROWNAMES.name(), oldValue, this.hasRownames);
        }
    }

    public void setRowNamesColumnIndex(int rowNamesColumnIndex) {
        if (this.rownamesColumnIndex != rowNamesColumnIndex) {
            int oldValue = this.rownamesColumnIndex;
            this.rownamesColumnIndex = rowNamesColumnIndex;
            if (this.hasRownames) {
                this.fireTableStructureChanged();
            }
            this.propertyChangeSupport.firePropertyChange(PROP.ROWNAMESCOLUMNINDEX.name(), oldValue, rowNamesColumnIndex);
        }
    }

    public void setRowStart(int rowStart) {
        if (this.rowStart != rowStart) {
            int oldStartValue = this.rowStart;
            this.rowStart = rowStart;
            if (oldStartValue < this.rowStart) {
                this.fireTableRowsDeleted(0, this.rowStart - oldStartValue - 1);
            } else {
                this.fireTableRowsInserted(0, oldStartValue - rowStart - 1);
            }
            this.propertyChangeSupport.firePropertyChange(PROP.RANGE_ROWSTART.name(), oldStartValue, this.rowStart);
        }
    }

    public int getRowStart() {
        return this.rowStart;
    }

    public void setRowEnd(int rowEnd) {
        if (this.rowEnd != rowEnd) {
            int oldEndValue = this.rowEnd;
            this.rowEnd = rowEnd;
            if (oldEndValue > this.rowEnd) {
                if (this.hasColnames) {
                    this.fireTableRowsDeleted(this.rowEnd - this.rowStart, oldEndValue - this.rowStart - 1);
                } else {
                    this.fireTableRowsDeleted(this.rowEnd - this.rowStart + 1, oldEndValue - this.rowStart);
                }
            } else if (this.hasColnames) {
                this.fireTableRowsInserted(oldEndValue - this.rowStart, this.rowEnd - this.rowStart - 1);
            } else {
                this.fireTableRowsInserted(oldEndValue - this.rowStart, this.rowEnd - this.rowStart);
            }
            this.propertyChangeSupport.firePropertyChange(PROP.RANGE_ROWEND.name(), oldEndValue, this.rowEnd);
        }
    }

    public int getRowEnd() {
        return this.rowEnd;
    }

    public void setColStart(int colStart) {
        if (this.colStart != colStart) {
            int oldValue = this.colStart;
            this.colStart = colStart;
            this.fireTableStructureChanged();
            this.propertyChangeSupport.firePropertyChange(PROP.RANGE_COLSTART.name(), oldValue, this.colStart);
        }
    }

    public int getColStart() {
        return this.colStart;
    }

    public void setColEnd(int colEnd) {
        if (this.colEnd != colEnd && colEnd < this.maxColumnCount) {
            int oldValue = this.colEnd;
            this.colEnd = colEnd;
            this.fireTableStructureChanged();
            this.propertyChangeSupport.firePropertyChange(PROP.RANGE_COLEND.name(), oldValue, this.colEnd);
        }
    }

    public int getColEnd() {
        return this.colEnd;
    }

    public int getMaxColumnCount() {
        return this.maxColumnCount;
    }

    public void clearAll() {
        this.clearing = true;
        this.setHasColumnNames(false);
        this.setColumnNamesRowIndex(0);
        this.setHasRowNames(false);
        this.setRowNamesColumnIndex(0);
        this.setRowStart(0);
        this.setRowEnd(0);
        this.setColStart(0);
        this.setColEnd(0);
        this.maxColumnCount = 0;
        this.allData.clear();
        this.classes.clear();
        this.columnMismatchCounter.clear();
        this.clearing = false;
    }

    public void convertToNumeric(int columnIndex) throws Exception {
        this.convertToNumeric(columnIndex, true, true);
    }

    private void convertToNumeric(int columnIndex, boolean checkfirstnumeric, boolean fireTableStructureChanged) throws Exception {
        if (this.getColumnClass(columnIndex) != Double.class) {
            if (checkfirstnumeric) {
                this.checkNumeric(columnIndex);
            }
            for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
                String val;
                this.allData.get((Object)Integer.valueOf((int)this.getRealRowIndex((int)rowIndex)))[this.getRealColumnIndex((int)columnIndex)] = this.getValueAt(rowIndex, columnIndex) == null ? null : ((val = StringUtils.trimToNull((String)this.getValueAt(rowIndex, columnIndex).toString())) == null || val.equalsIgnoreCase("NA") ? null : NumberUtils.createDouble((String)val));
            }
            this.classes.put(this.getRealColumnIndex(columnIndex), Double.class);
            if (fireTableStructureChanged) {
                this.fireTableStructureChanged();
            }
        }
    }

    private void checkNumeric(int columnIndex) throws Exception {
        StringBuilder err = new StringBuilder();
        err.append("Non-numeric values found in column ").append(this.getColumnName(columnIndex)).append("\nRows containing non-numeric values:\n");
        int failcount = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            String val;
            if (this.getValueAt(i, columnIndex) == null || (val = StringUtils.trimToNull((String)this.getValueAt(i, columnIndex).toString())) == null || val.equalsIgnoreCase("NA") || NumberUtils.isNumber((String)val)) continue;
            err.append(i + 1).append(",");
            if (++failcount != 5) continue;
            err.deleteCharAt(err.length() - 1);
            err.append("...");
            break;
        }
        if (failcount > 0) {
            this.columnMismatchCounter.put(this.getRealColumnIndex(columnIndex), failcount);
            throw new Exception(err.toString());
        }
    }

    public boolean containsNonNumeric(int columnIndex) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getValueAt(i, columnIndex) == null || StringUtils.isBlank((CharSequence)this.getValueAt(i, columnIndex).toString()) || NumberUtils.isNumber((String)this.getValueAt(i, columnIndex).toString())) continue;
            return true;
        }
        return false;
    }

    public void convertToText(int columnIndex, List<String> columndata) {
        if (columndata.size() != this.allData.size()) {
            throw new IllegalArgumentException("The size of the list containing column data is not equal to allData size.");
        }
        for (int i = 0; i < this.allData.size(); ++i) {
            this.allData.get((Object)Integer.valueOf((int)i))[this.getRealColumnIndex((int)columnIndex)] = columndata.get(i);
        }
        if (this.getColumnClass(columnIndex) != String.class) {
            this.classes.put(this.getRealColumnIndex(columnIndex), String.class);
            this.fireTableStructureChanged();
        }
    }

    public void convertToDate(int columnIndex, String[] pattern) throws Exception {
        if (this.getColumnClass(columnIndex) == RDate.class) {
            return;
        }
        if (this.getColumnClass(columnIndex) == RPOSIXct.class) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                this.allData.get((Object)Integer.valueOf((int)this.getRealRowIndex((int)i)))[this.getRealColumnIndex((int)columnIndex)] = new RDate((Date)this.getValueAt(i, columnIndex));
            }
            this.classes.put(this.getRealColumnIndex(columnIndex), RDate.class);
            this.fireTableStructureChanged();
            return;
        }
        ArrayList<Date> checkDate = this.checkDate(columnIndex, pattern);
        for (int i = 0; i < checkDate.size(); ++i) {
            this.allData.get((Object)Integer.valueOf((int)this.getRealRowIndex((int)i)))[this.getRealColumnIndex((int)columnIndex)] = checkDate.get(i) == null ? null : new RDate(checkDate.get(i));
        }
        this.classes.put(this.getRealColumnIndex(columnIndex), RDate.class);
        this.fireTableStructureChanged();
    }

    public void convertToPOSIXct(int columnIndex, String[] pattern) throws Exception {
        if (this.getColumnClass(columnIndex) == RPOSIXct.class) {
            return;
        }
        if (this.getColumnClass(columnIndex) == RDate.class) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                this.allData.get((Object)Integer.valueOf((int)this.getRealRowIndex((int)i)))[this.getRealColumnIndex((int)columnIndex)] = new RPOSIXct((Date)this.getValueAt(i, columnIndex));
            }
            this.classes.put(this.getRealColumnIndex(columnIndex), RPOSIXct.class);
            this.fireTableStructureChanged();
            return;
        }
        ArrayList<Date> checkDate = this.checkDate(columnIndex, pattern);
        for (int i = 0; i < checkDate.size(); ++i) {
            this.allData.get((Object)Integer.valueOf((int)this.getRealRowIndex((int)i)))[this.getRealColumnIndex((int)columnIndex)] = checkDate.get(i) == null ? null : new RPOSIXct(checkDate.get(i));
        }
        this.classes.put(this.getRealColumnIndex(columnIndex), RPOSIXct.class);
        this.fireTableStructureChanged();
    }

    private ArrayList<Date> checkDate(int columnIndex, String[] parsePatterns) throws Exception {
        SimpleDateFormat parser = new SimpleDateFormat();
        parser.setLenient(false);
        ParsePosition pos = new ParsePosition(0);
        StringBuilder err = new StringBuilder();
        err.append("Parse error on rows: ");
        ArrayList<Date> dates = new ArrayList<Date>();
        int failcount = 0;
        for (int i = 0; i < this.getRowCount() && failcount < 5; ++i) {
            if (this.getValueAt(i, columnIndex) != null && !StringUtils.isBlank((CharSequence)this.getValueAt(i, columnIndex).toString())) {
                try {
                    dates.add(this.parseDate(this.getValueAt(i, columnIndex).toString().trim(), parsePatterns, parser, pos));
                }
                catch (ParseException ex) {
                    ++failcount;
                    err.append(i + 1).append(',');
                }
                continue;
            }
            dates.add(null);
        }
        if (failcount > 0) {
            if (failcount == 5) {
                err.append("...");
            } else {
                err.deleteCharAt(err.length() - 1);
            }
            throw new Exception(err.toString());
        }
        return dates;
    }

    private Date parseDate(String str, String[] parsePatterns, SimpleDateFormat parser, ParsePosition pos) throws ParseException {
        for (int i = 0; i < parsePatterns.length; ++i) {
            String pattern = parsePatterns[i];
            parser.applyPattern(pattern);
            pos.setIndex(0);
            Date date = parser.parse(str, pos);
            if (date == null) continue;
            return date;
        }
        throw new ParseException("Unable to parse the date: " + str, -1);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PROP {
        HASCOLUMNNAMES,
        COLUMNNAMESROWINDEX,
        HASROWNAMES,
        ROWNAMESCOLUMNINDEX,
        RANGE_ROWSTART,
        RANGE_ROWEND,
        RANGE_COLSTART,
        RANGE_COLEND;

    }
}

