/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.speedr.importwizard.steps;

import at.ac.ait.speedr.workspace.RConnection;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;

public class DataSourcePanel
extends JPanel
implements DocumentListener {
    public static final String PROP_PASTE_DATA_CHANGED = "PROP_PASTE_DATA_CHANGED";
    public static final String PROP_URL_CHANGED = "PROP_URL_CHANGED";
    public static final String PROP_DATASOURCE_CHANGED = "PROP_DATASOURCE_CHANGED";
    public static final String PROP_FILE_DATASOURCE = "PROP_FILE_DATASOURCE";
    public static final String PROP_PASTEDATA_DATASOURCE = "PROP_PASTEDATA_DATASOURCE";
    public static final String PROP_URL_DATASOURCE = "PROP_URL_DATASOURCE";
    private static File lastUsedDir;
    private static String currentDataSource;
    private ButtonGroup buttonGroup1;
    private RSyntaxTextArea dataTextArea;
    private JFileChooser fileChooser;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JRadioButton rb_PasteData;
    private JRadioButton rb_SelectFile;
    private JRadioButton rb_URL;
    private JTextField urlTextField;

    public DataSourcePanel() {
        this.initComponents();
        this.fileChooser.setSelectedFile(null);
        try {
            lastUsedDir = new File(RConnection.eval("getwd()").asString());
        }
        catch (REngineException ex) {
            Logger.getLogger(DataSourcePanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (REXPMismatchException ex) {
            Logger.getLogger(DataSourcePanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.fileChooser.setCurrentDirectory(lastUsedDir);
    }

    public String getCurrentDataSource() {
        return currentDataSource;
    }

    public File getSelectedFile() {
        return this.fileChooser.getSelectedFile();
    }

    private void selectedFileChanged(PropertyChangeEvent evt) {
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        this.rb_SelectFile.setSelected(true);
        if (this.getSelectedFile() != null) {
            lastUsedDir = this.getSelectedFile().getParentFile();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void changedUpdate(DocumentEvent e) {
        if (this.dataTextArea.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PASTE_DATA_CHANGED, (Object)0, this.dataTextArea.getText().trim());
            this.rb_PasteData.setSelected(true);
        } else {
            this.firePropertyChange(PROP_URL_CHANGED, (Object)0, this.urlTextField.getText());
            this.rb_URL.setSelected(true);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane2 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.fileChooser = new JFileChooser();
        this.jScrollPane1 = new JScrollPane();
        this.dataTextArea = new RSyntaxTextArea();
        this.urlTextField = new JTextField();
        this.rb_SelectFile = new JRadioButton();
        this.rb_PasteData = new JRadioButton();
        this.rb_URL = new JRadioButton();
        this.setPreferredSize(new Dimension(475, 447));
        this.jScrollPane2.setBorder(null);
        this.jScrollPane2.setPreferredSize(null);
        this.fileChooser.setControlButtonsAreShown(false);
        this.fileChooser.addPropertyChangeListener("SelectedFileChangedProperty", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                DataSourcePanel.this.selectedFileChanged(evt);
            }
        });
        this.dataTextArea.setColumns(20);
        this.dataTextArea.setRows(4);
        this.dataTextArea.setHighlightCurrentLine(false);
        this.dataTextArea.getDocument().addDocumentListener(this);
        this.jScrollPane1.setViewportView((Component)this.dataTextArea);
        this.urlTextField.getDocument().addDocumentListener(this);
        this.buttonGroup1.add(this.rb_SelectFile);
        this.rb_SelectFile.setFont(new Font("Tahoma", 1, 11));
        this.rb_SelectFile.setText("Select File");
        this.rb_SelectFile.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                DataSourcePanel.this.rb_SelectFileItemStateChanged(evt);
            }
        });
        this.buttonGroup1.add(this.rb_PasteData);
        this.rb_PasteData.setFont(new Font("Tahoma", 1, 11));
        this.rb_PasteData.setText("Paste Data");
        this.rb_PasteData.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                DataSourcePanel.this.rb_PasteDataItemStateChanged(evt);
            }
        });
        this.buttonGroup1.add(this.rb_URL);
        this.rb_URL.setFont(new Font("Tahoma", 1, 11));
        this.rb_URL.setText("Enter URL");
        this.rb_URL.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                DataSourcePanel.this.rb_URLItemStateChanged(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 438, Short.MAX_VALUE)).addComponent(this.rb_PasteData).addComponent(this.rb_SelectFile).addComponent(this.fileChooser, -1, 448, Short.MAX_VALUE).addComponent(this.rb_URL).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.urlTextField, -1, 438, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.rb_SelectFile).addGap(1, 1, 1).addComponent(this.fileChooser, -2, 276, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rb_PasteData).addGap(1, 1, 1).addComponent(this.jScrollPane1, -1, 85, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rb_URL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.urlTextField, -2, -1, -2).addGap(97, 97, 97)));
        this.jScrollPane2.setViewportView(this.jPanel1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 475, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 462, Short.MAX_VALUE));
    }

    private void rb_SelectFileItemStateChanged(ItemEvent evt) {
        if (this.rb_SelectFile.isSelected()) {
            this.setDataSource(PROP_FILE_DATASOURCE);
        }
    }

    private void rb_PasteDataItemStateChanged(ItemEvent evt) {
        if (this.rb_PasteData.isSelected()) {
            this.setDataSource(PROP_PASTEDATA_DATASOURCE);
        }
    }

    private void rb_URLItemStateChanged(ItemEvent evt) {
        if (this.rb_URL.isSelected()) {
            this.setDataSource(PROP_URL_DATASOURCE);
        }
    }

    private void setDataSource(String datasource) {
        String oldValue = currentDataSource;
        currentDataSource = datasource;
        this.firePropertyChange(PROP_DATASOURCE_CHANGED, oldValue, currentDataSource);
    }

    public void setSelectedFile(File f) {
        this.fileChooser.setSelectedFile(f);
    }
}

