/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.speedr;

import at.ac.ait.dockingframes.theme.AITEclipseTheme;
import at.ac.ait.speedr.WorkspaceView;
import at.ac.ait.speedr.codegen.FilterFunctionCodeGen;
import at.ac.ait.speedr.codegen.ImportAndFilterCodeGen;
import at.ac.ait.speedr.importwizard.WizardIterator;
import at.ac.ait.speedr.importwizard.WizardPanel;
import at.ac.ait.speedr.importwizard.steps.DataImportPanel;
import at.ac.ait.speedr.table.POSIXctCellRenderer;
import at.ac.ait.speedr.table.RDate;
import at.ac.ait.speedr.table.RDateTimeConverter;
import at.ac.ait.speedr.table.RPOSIXct;
import at.ac.ait.speedr.table.RTableCellEditor;
import at.ac.ait.speedr.table.RTableCellRenderer;
import at.ac.ait.speedr.table.model.RAbstractTableModel;
import at.ac.ait.speedr.workspace.RConnection;
import at.ac.ait.speedr.workspace.RUtil;
import at.ac.arcs.tablefilter.ARCTable;
import at.ac.arcs.tablefilter.cell.DateCellRenderer;
import at.ac.arcs.tablefilter.events.FilterEvent;
import at.ac.arcs.tablefilter.events.FilterListener;
import at.ac.arcs.tablefilter.filtermodel.DateFilterDevice;
import at.ac.arcs.tablefilter.filtermodel.FilterDevice;
import at.ac.arcs.tablefilter.filtermodel.NumericFilterDevice;
import at.ac.arcs.tablefilter.filtermodel.StringFilterDevice;
import au.com.bytecode.opencsv.CSVWriter;
import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.gui.DockTheme;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CWorkingArea;
import bibliothek.gui.dock.common.DefaultMultipleCDockable;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.EmptyMultipleCDockableFactory;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.MultipleCDockableLayout;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.action.CButton;
import bibliothek.gui.dock.common.action.CMenu;
import bibliothek.gui.dock.common.action.predefined.CCloseAction;
import bibliothek.gui.dock.common.action.predefined.CNormalizeAction;
import bibliothek.gui.dock.common.event.CFocusListener;
import bibliothek.gui.dock.common.event.CVetoClosingEvent;
import bibliothek.gui.dock.common.event.CVetoClosingListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.theme.CDockThemeFactory;
import bibliothek.gui.dock.common.theme.CEclipseTheme;
import bibliothek.gui.dock.common.theme.ThemeMap;
import bibliothek.gui.dock.themes.ThemeFactory;
import bibliothek.gui.dock.themes.ThemePropertyFactory;
import com.google.common.base.Function;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.jdesktop.swingx.sort.DefaultSortController;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPFactor;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;

public class SpeedRFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(SpeedRFrame.class.getName());
    private static SpeedRFrame rif;
    private static final NumericFilterDevice numericFilterDevice;
    private static final RDateTimeConverter rDateTimeConverter;
    private static final StringFilterDevice stringFilterDevice;
    private final DateFilterDevice dateFilterDevice = new DateFilterDevice();
    private MultipleCDockableFactory<MultipleCDockable, MultipleCDockableLayout> multiDockFactory = new EmptyMultipleCDockableFactory<MultipleCDockable>(){

        public MultipleCDockable createDockable() {
            return new DefaultMultipleCDockable((MultipleCDockableFactory)this, new CAction[0]);
        }
    };
    private CControl control;
    private CWorkingArea tablesWorkArea;
    private DefaultSingleCDockable filtercode_dock;
    private DefaultMultipleCDockable activeDock;
    private DockCloseAction activeDockCloaseAction;
    private RSyntaxTextArea textArea;
    private ImageIcon exportIcon;
    private WorkspaceView workspace;
    private CFocusListener filterCodeDockTitleUpdater = new CFocusListener(){

        public void focusGained(CDockable dock) {
            SpeedRFrame.this.filtercode_dock.setTitleText("Filter Code - " + ((DefaultMultipleCDockable)dock).getTitleText());
        }

        public void focusLost(CDockable dock) {
            SpeedRFrame.this.filtercode_dock.setTitleText("Filter Code");
        }
    };

    private static SpeedRFrame getInstance() throws REngineException, REXPMismatchException {
        if (rif == null) {
            rif = new SpeedRFrame();
        }
        return rif;
    }

    private SpeedRFrame() {
        this.initComponents();
        this.initDocks();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setTitle("speedR");
        this.setMinimumSize(new Dimension(880, 650));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SpeedRFrame.this.formWindowClosing(evt);
            }
        });
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.activeDock != null) {
            this.activeDockCloaseAction.close((CDockable)this.activeDock);
            this.filtercode_dock.setTitleText("Filter Code");
            System.gc();
        }
    }

    private void initDocks() {
        try {
            this.exportIcon = new ImageIcon(SpeedRFrame.class.getResource("/at/ac/ait/speedr/icons/export_16.png"));
            this.control = new CControl((JFrame)this);
            ThemeMap tm = this.control.getThemes();
            final AITEclipseTheme theme = new AITEclipseTheme();
            CDockThemeFactory<AITEclipseTheme> arcseclipse = new CDockThemeFactory<AITEclipseTheme>(new ThemePropertyFactory(AITEclipseTheme.class), this.control){

                public DockTheme create(CControl control) {
                    return new CEclipseTheme(control, (EclipseTheme)theme);
                }
            };
            tm.add("KEY_ARCS_THEME", (ThemeFactory)arcseclipse);
            this.control.setTheme("KEY_ARCS_THEME");
            this.control.addMultipleDockableFactory("Tables", this.multiDockFactory);
            this.add((Component)this.control.getContentArea(), "Center");
            this.activeDockCloaseAction = new DockCloseAction(this.control);
            this.tablesWorkArea = this.control.createWorkingArea("tablesworkarea");
            DefaultSingleCDockable objmgr_dock = this.createObjectManagerDock();
            DefaultSingleCDockable filterCodeAreaDock = this.initFilterCodeAreaDock();
            objmgr_dock.setLocation((CLocation)CLocation.base().normalWest(0.3));
            this.tablesWorkArea.setLocation((CLocation)CLocation.base().normalEast(0.7));
            filterCodeAreaDock.setLocation((CLocation)CLocation.base().normalEast(0.7).south(0.2));
            filterCodeAreaDock.setLocation((CLocation)CLocation.base().minimalSouth());
            filterCodeAreaDock.setLocation((CLocation)CLocation.base().normalEast(0.7).south(0.2));
            objmgr_dock.setLocation((CLocation)CLocation.base().minimalWest());
            objmgr_dock.setLocation((CLocation)CLocation.base().normalWest(0.3));
            this.tablesWorkArea.setVisible(true);
        }
        catch (REngineException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (REXPMismatchException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private DefaultSingleCDockable createObjectManagerDock() throws REngineException, REXPMismatchException {
        this.workspace = new WorkspaceView(this);
        this.workspace.reload();
        DefaultSingleCDockable objmgr_dock = new DefaultSingleCDockable("Object Browser", "Object Browser", (Component)this.workspace, new CAction[0]);
        objmgr_dock.setCloseable(false);
        objmgr_dock.setExternalizable(false);
        objmgr_dock.setMinimizable(false);
        objmgr_dock.setMaximizable(false);
        objmgr_dock.addAction((CAction)new CButton("Refresh the object browser", new ImageIcon(SpeedRFrame.class.getResource("/at/ac/ait/speedr/icons/arrow_circle_double.png"))){

            protected void action() {
                try {
                    SpeedRFrame.this.workspace.reload();
                }
                catch (Exception ex) {
                    Logger.getLogger(SpeedRFrame.class.getName()).log(Level.SEVERE, null, ex);
                    JOptionPane.showMessageDialog(SpeedRFrame.this.workspace, "Can not reload workspace: " + ex.getMessage());
                }
            }
        });
        objmgr_dock.addAction((CAction)new CButton("Get Data", new ImageIcon(SpeedRFrame.class.getResource("/at/ac/ait/speedr/icons/import_16.png"))){

            protected void action() {
                SpeedRFrame.this.addImportDataDock();
            }
        });
        this.control.addDockable((SingleCDockable)objmgr_dock);
        objmgr_dock.setVisible(true);
        return objmgr_dock;
    }

    private DefaultSingleCDockable initFilterCodeAreaDock() {
        this.textArea = new RSyntaxTextArea();
        this.textArea.setHighlightCurrentLine(false);
        this.textArea.setSyntaxEditingStyle("text/java");
        RTextScrollPane sp = new RTextScrollPane((RTextArea)this.textArea);
        sp.setBorder(null);
        this.filtercode_dock = new DefaultSingleCDockable("filtercode", "Filter code", (Component)sp, new CAction[0]);
        this.filtercode_dock.setCloseable(false);
        this.filtercode_dock.setExternalizable(false);
        this.filtercode_dock.setMinimizable(false);
        this.control.addDockable((SingleCDockable)this.filtercode_dock);
        this.filtercode_dock.putAction("cdockable.normalize", (CAction)new CNormalizeAction(this.control){

            public void action(CDockable dockable) {
                dockable.setLocation((CLocation)CLocation.base().normalEast(0.7).south(0.3));
                super.action(dockable);
            }
        });
        this.filtercode_dock.setVisible(true);
        return this.filtercode_dock;
    }

    public void openTable(TableModel model, String objectname) {
        ARCTable arcTable = new ARCTable();
        arcTable.setHorizontalScrollEnabled(true);
        arcTable.setFilterRowHeaderVisibleColumnsMask(24);
        arcTable.setTableRowHeaderVisibleColumnsMask(2);
        arcTable.setGroupingEnabled(false);
        arcTable.setModel(model);
        arcTable.setColumnSelectorVisible(false);
        this.setComparators(arcTable, model);
        this.registerDeviceAndConverter(arcTable);
        this.setDefaultRendererAndEditor(arcTable);
        this.addFilterTable(arcTable, objectname);
    }

    private void setComparators(ARCTable table, TableModel model) {
        for (int i = 0; i < model.getColumnCount(); ++i) {
            if (model.getColumnClass(i) != REXPInteger.class && model.getColumnClass(i) != REXPDouble.class) continue;
            table.setComparator(i, DefaultSortController.COMPARABLE_COMPARATOR);
        }
    }

    private void registerDeviceAndConverter(ARCTable arcTable) {
        arcTable.registerFilterDevice(REXPInteger.class, (FilterDevice)numericFilterDevice);
        arcTable.registerFilterDevice(REXPDouble.class, (FilterDevice)numericFilterDevice);
        arcTable.registerFilterDevice(REXPFactor.class, (FilterDevice)stringFilterDevice);
        arcTable.registerFilterDevice(RDate.class, (FilterDevice)this.dateFilterDevice);
        arcTable.registerFilterDevice(RPOSIXct.class, (FilterDevice)this.dateFilterDevice);
        arcTable.registerConverter(RDate.class, (Function)rDateTimeConverter);
        arcTable.registerConverter(RPOSIXct.class, (Function)rDateTimeConverter);
    }

    private DefaultMultipleCDockable addFilterTable(final ARCTable table, String title) {
        DefaultMultipleCDockable docktable;
        this.textArea.setText("");
        if (this.activeDock != null) {
            this.activeDockCloaseAction.close((CDockable)this.activeDock);
        }
        String functionname = title.replace("[[\"", "_").replace("\"]]", "") + "_filter";
        boolean hasRownames = table.getModel().getColumnName(0).equals("row.names") || table.getModel().getColumnName(0).equals("dimnames[[1]]");
        final TableFilterListener listener = new TableFilterListener(functionname, hasRownames, (RAbstractTableModel)table.getModel());
        table.addFilterListener((FilterListener)listener);
        this.activeDock = docktable = this.createFilterTable(table, title);
        docktable.addVetoClosingListener(new CVetoClosingListener(){

            public void closing(CVetoClosingEvent event) {
            }

            public void closed(CVetoClosingEvent event) {
                SpeedRFrame.this.activeDock = null;
                table.setModel((TableModel)new DefaultTableModel());
                table.removeFilterListener(listener);
            }
        });
        return docktable;
    }

    private void setDefaultRendererAndEditor(ARCTable table) {
        RTableCellRenderer cr = new RTableCellRenderer(table.getDefaultRenderer(Object.class));
        table.setDefaultRenderer(Object.class, (TableCellRenderer)cr);
        table.setDefaultRenderer(REXPInteger.class, (TableCellRenderer)cr);
        table.setDefaultRenderer(REXPDouble.class, (TableCellRenderer)cr);
        table.setDefaultRenderer(REXPFactor.class, (TableCellRenderer)cr);
        table.setDefaultRenderer(String.class, (TableCellRenderer)cr);
        table.setDefaultRenderer(Boolean.class, (TableCellRenderer)cr);
        table.setDefaultRenderer(RDate.class, (TableCellRenderer)new DateCellRenderer());
        table.setDefaultRenderer(RPOSIXct.class, (TableCellRenderer)new POSIXctCellRenderer());
        RTableCellEditor editor = new RTableCellEditor(table.getDefaultEditor(Object.class));
        table.setDefaultEditor(Object.class, (TableCellEditor)editor);
        table.setDefaultEditor(REXPInteger.class, (TableCellEditor)editor);
        table.setDefaultEditor(REXPDouble.class, (TableCellEditor)editor);
        table.setDefaultEditor(REXPFactor.class, (TableCellEditor)editor);
        table.setDefaultEditor(String.class, (TableCellEditor)editor);
        table.setDefaultEditor(RDate.class, (TableCellEditor)new RTableCellEditor(table.getDefaultEditor(Date.class)));
        table.setDefaultEditor(RPOSIXct.class, (TableCellEditor)new RTableCellEditor(table.getDefaultEditor(Date.class)));
    }

    private DefaultMultipleCDockable createFilterTable(ARCTable table, String title) {
        DefaultMultipleCDockable dockableTable = new DefaultMultipleCDockable(this.multiDockFactory, title, (Component)table, new CAction[0]);
        dockableTable.setRemoveOnClose(true);
        dockableTable.setCloseable(true);
        dockableTable.setMinimizable(false);
        dockableTable.setExternalizable(false);
        dockableTable.addAction((CAction)new ExportAction(table));
        dockableTable.addSeparator();
        this.tablesWorkArea.add((MultipleCDockable)dockableTable);
        dockableTable.setVisible(true);
        dockableTable.toFront();
        dockableTable.addFocusListener(this.filterCodeDockTitleUpdater);
        return dockableTable;
    }

    private void addImportDataDock() {
        ImportAndFilterCodeGen importandfiltercodegen;
        DefaultMultipleCDockable dockable;
        this.textArea.setText("");
        if (this.activeDock != null) {
            this.activeDockCloaseAction.close((CDockable)this.activeDock);
            this.filtercode_dock.setTitleText("Filter Code");
        }
        final WizardIterator iterator = new WizardIterator();
        final WizardPanel wizardpanel = new WizardPanel(iterator);
        this.activeDock = dockable = this.createImportDataDock(wizardpanel);
        try {
            importandfiltercodegen = new ImportAndFilterCodeGen();
            importandfiltercodegen.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    SpeedRFrame.this.textArea.setText(importandfiltercodegen.getImportAndFilterCode().trim());
                }
            });
            iterator.setDataImportPanelUserActionListener(importandfiltercodegen);
            iterator.setDataImportTableFilterListener(importandfiltercodegen);
        }
        catch (IOException ex) {
            Logger.getLogger(SpeedRFrame.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(this, "Import and Filter code genarator could not be initialized!");
            return;
        }
        final PropertyChangeListener wpListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "WizardPanel_stateChanged" && evt.getNewValue() == "WizardPanel_stateFinished") {
                    logger.log(Level.INFO, "Finish state entry");
                    SwingWorker<Boolean, Object> worker = new SwingWorker<Boolean, Object>(){

                        @Override
                        protected Boolean doInBackground() throws Exception {
                            REXPGenericVector dataframe2 = wizardpanel.getDataframe();
                            String varname = (String)wizardpanel.getProperty("VARIABLENAME");
                            RConnection.exportDataFrame(varname, dataframe2);
                            return null;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        protected void done() {
                            try {
                                this.get();
                                logger.log(Level.INFO, "export to R successfull.");
                                SpeedRFrame.this.workspace.reload();
                            }
                            catch (Exception ex) {
                                logger.log(Level.WARNING, ex.getMessage(), ex);
                                JOptionPane.showMessageDialog(SpeedRFrame.this, "Error during exporting to R:\n" + ex.getMessage(), "Error", 0);
                            }
                            finally {
                                wizardpanel.displayProgress(false);
                                logger.log(Level.INFO, "Export to R finished.");
                            }
                        }
                    };
                    worker.execute();
                    try {
                        worker.get();
                    }
                    catch (Exception ex) {
                        Logger.getLogger(SpeedRFrame.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    SpeedRFrame.this.activeDockCloaseAction.close((CDockable)dockable);
                } else if (evt.getPropertyName() == "WizardPanel_stateChanged" && evt.getNewValue() == "WizardPanel_stateCanceled") {
                    SpeedRFrame.this.activeDockCloaseAction.close((CDockable)dockable);
                } else if ("PROP_FILE".equals(evt.getPropertyName())) {
                    importandfiltercodegen.setFile(evt.getNewValue().toString().replaceAll("\\\\", "/"));
                    SpeedRFrame.this.textArea.setText(importandfiltercodegen.getImportAndFilterCode().trim());
                } else if (evt.getPropertyName() == "WizardPanel_stateChanged" && evt.getNewValue() == "WizardPanel_statenext") {
                    importandfiltercodegen.setModel(((DataImportPanel)iterator.current().getComponent()).getTableModel());
                }
            }
        };
        wizardpanel.addPropertyChangeListener(wpListener);
        dockable.addVetoClosingListener(new CVetoClosingListener(){

            public void closing(CVetoClosingEvent event) {
                wizardpanel.removePropertyChangeListener(wpListener);
                wizardpanel.callUnininitialize();
                wizardpanel.setDataframeToNull();
                importandfiltercodegen.setModel(null);
                System.gc();
            }

            public void closed(CVetoClosingEvent event) {
            }
        });
    }

    private DefaultMultipleCDockable createImportDataDock(WizardPanel wizardpanel) {
        DefaultMultipleCDockable dockable = new DefaultMultipleCDockable(this.multiDockFactory, "Get Data", (Component)wizardpanel, new CAction[0]);
        dockable.setRemoveOnClose(true);
        dockable.setCloseable(true);
        dockable.setMinimizable(false);
        dockable.setExternalizable(false);
        dockable.putAction("cdockable.close", (CAction)this.activeDockCloaseAction);
        this.tablesWorkArea.add((MultipleCDockable)dockable);
        dockable.setVisible(true);
        return dockable;
    }

    private void exportTableToR(ARCTable arctable, String varname) throws REngineException, REXPMismatchException {
        REXPGenericVector dataFrame = RUtil.createRDataFrame(arctable);
        RConnection.exportDataFrame(varname, dataFrame);
    }

    private void exportTableToTabDelimitedFile(ARCTable table, File file) throws IOException {
        this.exportTableToFile(table, file, '\t', '\u0000');
    }

    private void exportTableToCSV(ARCTable table, File file) throws IOException {
        this.exportTableToFile(table, file, ',', '\"');
    }

    private void exportTableToFile(ARCTable table, File file, char separator, char quote) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        CSVWriter csvwriter = new CSVWriter((Writer)writer, separator, quote);
        ArrayList<String> row = new ArrayList<String>(table.getColumnCount());
        for (int i = 0; i < table.getColumnCount(); ++i) {
            row.add(table.getColumnName(i));
        }
        csvwriter.writeNext(row.toArray(new String[row.size()]));
        for (int rowIndex = 0; rowIndex < table.getRowCount(); ++rowIndex) {
            row = new ArrayList(table.getColumnCount());
            for (int columnIndex = 0; columnIndex < table.getColumnCount(); ++columnIndex) {
                row.add(table.getValueAt(rowIndex, columnIndex) == null ? "" : table.getValueAt(rowIndex, columnIndex).toString());
            }
            csvwriter.writeNext(row.toArray(new String[row.size()]));
        }
        csvwriter.close();
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (!SpeedRFrame.isMac()) {
                    try {
                        UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
                    }
                    catch (Exception ex) {
                        logger.log(Level.WARNING, null, ex);
                    }
                }
                try {
                    SpeedRFrame rifInstance = SpeedRFrame.getInstance();
                    rifInstance.setVisible(true);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    static {
        numericFilterDevice = new NumericFilterDevice();
        rDateTimeConverter = new RDateTimeConverter();
        stringFilterDevice = new StringFilterDevice();
    }

    private class ExportAction
    extends CMenu {
        private ARCTable table;
        private JFileChooser fc;

        public ExportAction(ARCTable table) {
            super("Export To ...", (Icon)SpeedRFrame.this.exportIcon);
            this.table = table;
            this.init();
        }

        private void init() {
            this.fc = new JFileChooser();
            this.add(this.createExportToRAction());
            this.add(this.createExportToCSVAction());
            this.add(this.createExportToTabDelimitedAction());
        }

        private CAction createExportToRAction() {
            return new CButton("Export to R Workspace", SpeedRFrame.this.exportIcon){

                protected void action() {
                    try {
                        String varname = JOptionPane.showInputDialog("Enter a variable name for the new object");
                        if (SpeedRFrame.this.workspace.hasVariable(varname)) {
                            int showConfirmDialog = JOptionPane.showConfirmDialog((Component)ExportAction.this.table, "A variable with the name " + varname + " exsists already!\n" + "Do you want to replace it?");
                            if (showConfirmDialog == 0) {
                                SpeedRFrame.this.exportTableToR(ExportAction.this.table, varname);
                            }
                        } else {
                            SpeedRFrame.this.exportTableToR(ExportAction.this.table, varname);
                            SpeedRFrame.this.workspace.reload();
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(rif, "Export failed!");
                        Logger.getLogger(SpeedRFrame.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            };
        }

        private CAction createExportToCSVAction() {
            return new CButton("Export as csv file", SpeedRFrame.this.exportIcon){

                protected void action() {
                    int val = ExportAction.this.fc.showSaveDialog((Component)ExportAction.this.table);
                    if (val == 0) {
                        try {
                            File f = ExportAction.this.fc.getSelectedFile();
                            if (!f.getName().contains(".csv")) {
                                f = new File(f.getParent(), f.getName() + ".csv");
                            }
                            SpeedRFrame.this.exportTableToCSV(ExportAction.this.table, f);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(SpeedRFrame.class.getName()).log(Level.SEVERE, null, ex);
                            JOptionPane.showMessageDialog((Component)ExportAction.this.table, "Export failed: " + ex.getMessage());
                        }
                    }
                }
            };
        }

        private CAction createExportToTabDelimitedAction() {
            return new CButton("Export as tab-delimited (.txt) file", SpeedRFrame.this.exportIcon){

                protected void action() {
                    int val = ExportAction.this.fc.showSaveDialog((Component)ExportAction.this.table);
                    if (val == 0) {
                        try {
                            File f = ExportAction.this.fc.getSelectedFile();
                            if (!f.getName().contains(".txt")) {
                                f = new File(f.getParent(), f.getName() + ".txt");
                            }
                            SpeedRFrame.this.exportTableToTabDelimitedFile(ExportAction.this.table, f);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(SpeedRFrame.class.getName()).log(Level.SEVERE, null, ex);
                            JOptionPane.showMessageDialog((Component)ExportAction.this.table, "Export failed: " + ex.getMessage());
                        }
                    }
                }
            };
        }
    }

    private class TableFilterListener
    implements FilterListener {
        private FilterFunctionCodeGen codegen;
        private String functionname;
        private RAbstractTableModel model;
        private boolean hasRownames = false;

        public TableFilterListener(String functionname, boolean hasRownames, RAbstractTableModel model) {
            this.functionname = functionname;
            this.model = model;
            this.hasRownames = hasRownames;
            try {
                this.codegen = new FilterFunctionCodeGen();
            }
            catch (IOException ex) {
                Logger.getLogger(SpeedRFrame.class.getName()).log(Level.SEVERE, "Filter function code genarator could not be initialized!", ex);
            }
        }

        public void filterChanged(FilterEvent event) {
            String filterFunctionCode = this.codegen.getFilterFunctionCode(this.functionname, event.getFilterInfo(), this.hasRownames, this.model);
            SpeedRFrame.this.textArea.setText(filterFunctionCode.trim());
        }
    }

    private class DockCloseAction
    extends CCloseAction {
        public DockCloseAction(CControl control) {
            super(control);
        }

        public void close(CDockable cd) {
            super.close(cd);
            SpeedRFrame.this.activeDock = null;
        }
    }
}

