/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.speedr.codegen;

import at.ac.ait.speedr.codegen.FilterExpressionRCodeGen;
import at.ac.ait.speedr.table.RPOSIXct;
import at.ac.ait.speedr.table.model.RAbstractTableModel;
import at.ac.ait.speedr.table.model.twodim.RDataFrameTableModel;
import at.ac.arcs.tablefilter.filtermodel.DateFilterDevice;
import at.ac.arcs.tablefilter.filtermodel.NumericFilterDevice;
import at.ac.arcs.tablefilter.filtermodel.info.FilterColumnInfo;
import at.ac.arcs.tablefilter.filtermodel.info.FilterInfo;
import at.ac.arcs.tablefilter.filtermodel.info.FilterRowInfo;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ait.table.filter.FilterExpressionLexer;
import org.ait.table.filter.FilterExpressionParser;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;

public class FilterFunctionCodeGen {
    private static StringTemplateGroup stg;

    public FilterFunctionCodeGen() throws IOException {
        if (stg == null) {
            InputStreamReader r = new InputStreamReader(FilterFunctionCodeGen.class.getResourceAsStream("/at/ac/ait/speedr/codegen/template/RCodeGen.stg"));
            stg = new StringTemplateGroup((Reader)r);
            r.close();
        }
    }

    public String getFilterFunctionCode(String functionname, FilterInfo filterInfo, boolean hasRowname, RAbstractTableModel tableModel) {
        FilterRowInfo[] filterRows;
        StringTemplate filterfunction = stg.getInstanceOf("filterfunction");
        filterfunction.setAttribute("functionname", (Object)functionname);
        for (FilterRowInfo filterRowInfo : filterRows = filterInfo.getFilterRows()) {
            StringTemplate filterlevel = stg.getInstanceOf("filterlevel");
            List columns = filterRowInfo.getColumns();
            if (columns.isEmpty()) continue;
            for (FilterColumnInfo filterColumnInfo : columns) {
                String exp = filterColumnInfo.getExpression();
                try {
                    ANTLRStringStream input = new ANTLRStringStream(exp);
                    FilterExpressionLexer lexer = new FilterExpressionLexer((CharStream)input);
                    CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
                    FilterExpressionParser parser = new FilterExpressionParser((TokenStream)tokens);
                    lexer.setNumberColumn(filterInfo.getFilterDevices()[filterColumnInfo.getColumn()] instanceof NumericFilterDevice);
                    parser.setNumberColumn(filterInfo.getFilterDevices()[filterColumnInfo.getColumn()] instanceof NumericFilterDevice);
                    parser.setDateColumn(filterInfo.getFilterDevices()[filterColumnInfo.getColumn()] instanceof DateFilterDevice);
                    FilterExpressionParser.formula_return formula = parser.formula();
                    CommonTree tree = (CommonTree)formula.getTree();
                    CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)tree);
                    nodes.setTokenStream((TokenStream)tokens);
                    FilterExpressionRCodeGen rcodegen = new FilterExpressionRCodeGen((TreeNodeStream)nodes);
                    int col = filterColumnInfo.getColumn();
                    if (hasRowname && col == 0) {
                        rcodegen.setHasRowNames(hasRowname);
                        rcodegen.setColumnIndex(tableModel.getRownameIndexCode("x"));
                    } else {
                        rcodegen.setColumnIndex(tableModel.getColumnIndexCode(col));
                    }
                    if (tableModel instanceof RDataFrameTableModel) {
                        rcodegen.setDataframe(true);
                        rcodegen.setDataframeColumnIndex(tableModel.getColumnName(col));
                    }
                    if (tableModel.getColumnClass(col) == RPOSIXct.class) {
                        rcodegen.setPOSIXct(true);
                    }
                    rcodegen.setTemplateLib(stg);
                    FilterExpressionRCodeGen.rcode_return rcode = rcodegen.rcode();
                    filterlevel.setAttribute("selectors", (Object)rcode.st);
                }
                catch (RecognitionException recognitionException) {
                    Logger.getLogger(FilterFunctionCodeGen.class.getName()).log(Level.SEVERE, "Can't parse the expression: " + exp, recognitionException);
                }
            }
            filterfunction.setAttribute("filterlevels", (Object)filterlevel);
        }
        if (filterfunction.getAttribute("filterlevels") == null) {
            return "";
        }
        return filterfunction.toString();
    }
}

