/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference.preferences.choice;

import bibliothek.extension.gui.dock.preference.preferences.choice.Choice;
import bibliothek.extension.gui.dock.preference.preferences.choice.ChoiceExtension;
import bibliothek.gui.DockController;
import bibliothek.gui.dock.util.extension.ExtensionName;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultChoice<V>
implements Choice {
    private List<Entry> list = new ArrayList<Entry>();
    private boolean nullEntryAllowed = false;
    private String defaultChoice;

    public DefaultChoice(DockController dockController) {
        if (dockController != null) {
            ExtensionName<ChoiceExtension> extensionName = new ExtensionName<ChoiceExtension>(ChoiceExtension.CHOICE_EXTENSION, ChoiceExtension.class, "choice", this);
            List<ChoiceExtension> list = dockController.getExtensions().load(extensionName);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ChoiceExtension choiceExtension;
                ChoiceExtension choiceExtension2 = choiceExtension = (ChoiceExtension)iterator.next();
                int n = choiceExtension2.size();
                for (int i = 0; i < n; ++i) {
                    String string = choiceExtension2.getText(i);
                    String string2 = choiceExtension2.getId(i);
                    Object v = choiceExtension2.getChoice(i);
                    this.add(string2, string, v);
                }
                if (this.defaultChoice != null) continue;
                this.defaultChoice = choiceExtension2.getDefaultChoice();
            }
        }
    }

    public void remove(int n) {
        this.list.remove(n);
    }

    public void add(String string, String string2, V v) {
        if (string == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        this.list.add(new Entry(string, string2, v));
    }

    @Override
    public String getId(int n) {
        return this.list.get((int)n).id;
    }

    @Override
    public String getText(int n) {
        return this.list.get((int)n).text;
    }

    public V getValue(int n) {
        return this.list.get((int)n).value;
    }

    public int indexOfIdentifier(String string) {
        if (string == null) {
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                if (this.list.get((int)i).id != null) continue;
                return i;
            }
        } else {
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                if (!this.list.get((int)i).id.equals(string)) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOfValue(V v) {
        if (v == null) {
            return -1;
        }
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            if (!this.equals(this.list.get((int)i).value, v)) continue;
            return i;
        }
        return -1;
    }

    protected boolean equals(V v, V v2) {
        if (v == v2) {
            return true;
        }
        if (v == null) {
            return false;
        }
        return v.equals(v2);
    }

    public String valueToIdentifier(V v) {
        int n = this.indexOfValue(v);
        if (n < 0) {
            return null;
        }
        return this.getId(n);
    }

    public V identifierToValue(String string) {
        int n = this.indexOfIdentifier(string);
        if (n < 0) {
            return null;
        }
        return this.getValue(n);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    public void setNullEntryAllowed(boolean bl) {
        this.nullEntryAllowed = bl;
    }

    @Override
    public boolean isNullEntryAllowed() {
        return this.nullEntryAllowed;
    }

    public void setDefaultChoice(String string) {
        this.defaultChoice = string;
    }

    @Override
    public String getDefaultChoice() {
        if (this.defaultChoice == null) {
            if (this.isNullEntryAllowed()) {
                return null;
            }
            if (this.list.size() > 0) {
                return this.list.get((int)0).id;
            }
            return null;
        }
        return this.defaultChoice;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry {
        public String id;
        public String text;
        public V value;

        public Entry(String string, String string2, V v) {
            this.id = string;
            this.text = string2;
            this.value = v;
        }
    }
}

