/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.flat;

import bibliothek.extension.gui.dock.theme.flat.FlatTabPane;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.menu.AbstractCombinedMenu;
import bibliothek.gui.dock.themes.color.MenuColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

public class FlatMenu
extends AbstractCombinedMenu {
    private FlatTabPane pane;
    private Component component;
    private FlatMenuColor buttonEdge = new FlatMenuColor("stack.menu.edge");
    private FlatMenuColor buttonMiddle = new FlatMenuColor("stack.menu.middle");
    private FlatMenuColor buttonEdgeSelected = new FlatMenuColor("stack.menu.edge.selected");
    private FlatMenuColor buttonMiddleSelected = new FlatMenuColor("stack.menu.middle.selected");

    public FlatMenu(FlatTabPane flatTabPane) {
        super(flatTabPane, flatTabPane.getMenuHandler());
        this.pane = flatTabPane;
    }

    protected Component createComponent() {
        this.component = new Button();
        return this.component;
    }

    protected void selected(Dockable dockable) {
        this.pane.setSelectedDockable(dockable);
    }

    public void setController(DockController dockController) {
        super.setController(dockController);
        this.buttonEdge.connect(dockController);
        this.buttonMiddle.connect(dockController);
        this.buttonEdgeSelected.connect(dockController);
        this.buttonMiddleSelected.connect(dockController);
    }

    private class FlatMenuColor
    extends MenuColor {
        public FlatMenuColor(String string) {
            super(string, FlatMenu.this.pane.getStation(), FlatMenu.this, null);
        }

        protected void changed(Color color, Color color2) {
            if (FlatMenu.this.component != null) {
                FlatMenu.this.component.repaint();
            }
        }
    }

    private class Button
    extends JPanel {
        private boolean mouseInsideButton = false;

        public Button() {
            this.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    Button.this.mouseInsideButton = true;
                    Button.this.repaint();
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    Button.this.mouseInsideButton = false;
                    Button.this.repaint();
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    FlatMenu.this.open();
                }
            });
            this.setPreferredSize(new Dimension(20, 20));
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Color color = null;
            Color color2 = null;
            if (this.mouseInsideButton) {
                color = FlatMenu.this.buttonEdgeSelected.color();
                color2 = FlatMenu.this.buttonMiddleSelected.color();
            }
            if (color == null) {
                color = FlatMenu.this.buttonEdge.color();
            }
            if (color2 == null) {
                color2 = FlatMenu.this.buttonMiddleSelected.color();
            }
            if (color == null) {
                color = this.getBackground();
            }
            if (color2 == null) {
                color2 = this.getBackground();
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color, (n + 1) / 2, 0.0f, color2));
            graphics2D.drawLine(0, 0, n, 0);
            graphics2D.drawLine(0, n2 - 1, n, n2 - 1);
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, color, 0.0f, (n2 + 1) / 2, color2));
            graphics2D.drawLine(0, 0, 0, n2);
            graphics2D.drawLine(n - 1, 0, n - 1, n2);
        }
    }
}

