/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.actions;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionType;
import bibliothek.gui.dock.action.SelectableDockAction;
import bibliothek.gui.dock.action.actions.GroupKeyGenerator;
import bibliothek.gui.dock.action.actions.GroupedDropDownItemAction;
import bibliothek.gui.dock.action.actions.SimpleSelectableAction;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.SelectableDockActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GroupedSelectableDockAction<K>
extends GroupedDropDownItemAction<K, SimpleSelectableAction>
implements SelectableDockAction {
    private List<SelectableDockActionListener> listeners = new ArrayList<SelectableDockActionListener>();
    private ActionType<SelectableDockAction> type;
    private SelectableDockActionListener listener = new SelectableDockActionListener(){

        @Override
        public void selectedChanged(SelectableDockAction selectableDockAction, Set<Dockable> set) {
            GroupedSelectableDockAction.this.fireSelectedChanged(set);
        }
    };

    public GroupedSelectableDockAction(GroupKeyGenerator<? extends K> groupKeyGenerator, ActionType<SelectableDockAction> actionType) {
        super(groupKeyGenerator);
        if (actionType == null) {
            throw new IllegalArgumentException("Type must not be null");
        }
        this.type = actionType;
    }

    @Override
    public void setGroup(K k, Dockable dockable) {
        super.setGroup(k, dockable);
        this.fireSelectedChanged(dockable);
    }

    @Override
    public <V> V createView(ViewTarget<V> viewTarget, ActionViewConverter actionViewConverter, Dockable dockable) {
        return actionViewConverter.createView(this.type, this, viewTarget, dockable);
    }

    @Override
    public void addSelectableListener(SelectableDockActionListener selectableDockActionListener) {
        this.listeners.add(selectableDockActionListener);
    }

    @Override
    public void removeSelectableListener(SelectableDockActionListener selectableDockActionListener) {
        this.listeners.remove(selectableDockActionListener);
    }

    @Override
    protected SimpleSelectableAction createGroup(K k) {
        return this.createGroup(this.listener);
    }

    @Override
    protected abstract SimpleSelectableAction createGroup(SelectableDockActionListener var1);

    protected void fireSelectedChanged(Dockable dockable) {
        HashSet<Dockable> hashSet = new HashSet<Dockable>();
        hashSet.add(dockable);
        this.fireSelectedChanged(hashSet);
    }

    protected void fireSelectedChanged(Set<Dockable> set) {
        for (SelectableDockActionListener selectableDockActionListener : this.listeners.toArray(new SelectableDockActionListener[this.listeners.size()])) {
            selectableDockActionListener.selectedChanged(this, set);
        }
    }

    @Override
    public boolean isSelected(Dockable dockable) {
        return ((SimpleSelectableAction)this.getGroup(dockable)).isSelected(dockable);
    }

    @Override
    public void setSelected(Dockable dockable, boolean bl) {
        ((SimpleSelectableAction)this.getGroup(dockable)).setSelected(dockable, bl);
    }

    public void setSelected(K k, boolean bl) {
        ((SimpleSelectableAction)this.ensureGroup(k)).setSelected(bl);
    }

    public boolean isSelected(Object object) {
        SimpleSelectableAction simpleSelectableAction = (SimpleSelectableAction)this.getGroup(object);
        if (simpleSelectableAction == null) {
            throw new IllegalArgumentException("There is no such group");
        }
        return simpleSelectableAction.isSelected();
    }

    public void setSelectedIcon(K k, Icon icon) {
        ((SimpleSelectableAction)this.ensureGroup(k)).setSelectedIcon(icon);
    }

    public Icon getSelectedIcon(Object object) {
        SimpleSelectableAction simpleSelectableAction = (SimpleSelectableAction)this.getGroup(object);
        if (simpleSelectableAction == null) {
            throw new IllegalArgumentException("There is no such group");
        }
        return simpleSelectableAction.getSelectedIcon();
    }

    public void setDisabledSelectedIcon(K k, Icon icon) {
        ((SimpleSelectableAction)this.ensureGroup(k)).setDisabledSelectedIcon(icon);
    }

    public Icon getDisabledSelectedIcon(Object object) {
        SimpleSelectableAction simpleSelectableAction = (SimpleSelectableAction)this.getGroup(object);
        if (simpleSelectableAction == null) {
            throw new IllegalArgumentException("There is no such group");
        }
        return simpleSelectableAction.getDisabledSelectedIcon();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Radio<K>
    extends GroupedSelectableDockAction<K> {
        public Radio(GroupKeyGenerator<? extends K> groupKeyGenerator) {
            super(groupKeyGenerator, ActionType.RADIO);
        }

        @Override
        protected SimpleSelectableAction createGroup(SelectableDockActionListener selectableDockActionListener) {
            SimpleSelectableAction.Radio radio = new SimpleSelectableAction.Radio();
            radio.addSelectableListener(selectableDockActionListener);
            return radio;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Check<K>
    extends GroupedSelectableDockAction<K> {
        public Check(GroupKeyGenerator<? extends K> groupKeyGenerator) {
            super(groupKeyGenerator, ActionType.CHECK);
        }

        @Override
        protected SimpleSelectableAction createGroup(SelectableDockActionListener selectableDockActionListener) {
            SimpleSelectableAction.Check check = new SimpleSelectableAction.Check();
            check.addSelectableListener(selectableDockActionListener);
            return check;
        }
    }
}

