/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.bubble;

import bibliothek.extension.gui.dock.theme.bubble.BubbleColorAnimation;
import bibliothek.extension.gui.dock.theme.bubble.RoundButtonConnectable;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModelAdapter;
import bibliothek.gui.dock.themes.basic.action.BasicResourceInitializer;
import bibliothek.gui.dock.themes.basic.action.BasicTrigger;
import bibliothek.gui.dock.themes.color.ActionColor;
import bibliothek.gui.dock.util.AbstractPaintableComponent;
import bibliothek.gui.dock.util.BackgroundComponent;
import bibliothek.gui.dock.util.BackgroundPaint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Icon;
import javax.swing.JComponent;

public class RoundButton
extends JComponent
implements RoundButtonConnectable {
    private BubbleColorAnimation animation;
    private BasicButtonModel model;
    private RoundActionColor[] colors;

    public RoundButton(BasicTrigger trigger, BasicResourceInitializer initializer, Dockable dockable, DockAction action) {
        this.setFocusable(true);
        this.animation = new BubbleColorAnimation();
        this.colors = new RoundActionColor[]{new RoundActionColor("action.button", dockable, action, Color.WHITE), new RoundActionColor("action.button.enabled", dockable, action, Color.LIGHT_GRAY), new RoundActionColor("action.button.selected", dockable, action, Color.YELLOW), new RoundActionColor("action.button.selected.enabled", dockable, action, Color.ORANGE), new RoundActionColor("action.button.mouse.enabled", dockable, action, Color.RED), new RoundActionColor("action.button.mouse.selected.enabled", dockable, action, new Color(128, 0, 0)), new RoundActionColor("action.button.pressed.enabled", dockable, action, Color.BLUE), new RoundActionColor("action.button.pressed.selected.enabled", dockable, action, Color.MAGENTA), new RoundActionColor("action.button.focus", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.button.enabled.focus", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.button.selected.focus", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.button.selected.enabled.focus", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.button.mouse.enabled.focus", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.button.mouse.selected.enabled.focus", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.button.pressed.enabled.focus", dockable, action, Color.DARK_GRAY), new RoundActionColor("action.button.pressed.selected.enabled.focus", dockable, action, Color.DARK_GRAY)};
        this.model = new BasicButtonModel(this, trigger, initializer){

            public void changed() {
                RoundButton.this.updateColors();
                RoundButton.this.repaint();
            }
        };
        this.model.addListener(new BasicButtonModelAdapter(){

            public void mousePressed(BasicButtonModel model, boolean mousePressed) {
                if (mousePressed) {
                    RoundButton.this.requestFocusInWindow();
                }
            }
        });
        this.updateColors();
        this.animation.addTask(new Runnable(){

            public void run() {
                RoundButton.this.repaint();
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                RoundButton.this.repaint();
            }

            public void focusLost(FocusEvent e) {
                RoundButton.this.repaint();
            }
        });
    }

    public void setController(DockController controller) {
        for (RoundActionColor color : this.colors) {
            color.connect(controller);
        }
        this.animation.kick();
    }

    public BasicButtonModel getModel() {
        return this.model;
    }

    public boolean contains(int x, int y) {
        double dy;
        double dx;
        double delta;
        double h;
        if (!super.contains(x, y)) {
            return false;
        }
        double w = this.getWidth();
        if (w > (h = (double)this.getHeight())) {
            delta = h / w;
            dx = x;
            dy = delta * (double)y;
            h = w;
        } else {
            delta = w / h;
            dx = delta * (double)x;
            dy = y;
            w = h;
        }
        double dist = (dx -= w / 2.0) * dx + (dy -= h / 2.0) * dy;
        return dist <= w * w / 4.0;
    }

    public Dimension getPreferredSize() {
        Dimension icon = this.model.getMaxIconSize();
        icon.width = Math.max(icon.width, 10);
        icon.height = Math.max(icon.height, 10);
        return new Dimension((int)((double)icon.width * 1.5), (int)((double)icon.height * 1.5));
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BackgroundPaint paint = this.model.getBackground();
        BackgroundComponent component = this.model.getBackgroundComponent();
        if (paint == null) {
            this.doPaintBackground(g2);
            this.doPaintForeground(g2);
        } else {
            AbstractPaintableComponent paintable = new AbstractPaintableComponent(component, this, paint){

                protected void foreground(Graphics g) {
                    RoundButton.this.doPaintForeground(g);
                }

                protected void background(Graphics g) {
                    RoundButton.this.doPaintBackground(g);
                }

                protected void border(Graphics g) {
                }

                protected void children(Graphics g) {
                }

                protected void overlay(Graphics g) {
                }

                public boolean isSolid() {
                    return false;
                }

                public boolean isTransparent() {
                    return false;
                }
            };
            paintable.paint(g2);
        }
        g2.dispose();
    }

    private void doPaintBackground(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.animation.getColor("button"));
        g2.fillOval(0, 0, this.getWidth(), this.getHeight());
    }

    private void doPaintForeground(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Icon icon = this.model.getPaintIcon();
        if (icon != null) {
            icon.paintIcon(this, g, (this.getWidth() - icon.getIconWidth()) / 2, (this.getHeight() - icon.getIconHeight()) / 2);
        }
        if (this.hasFocus() && this.isFocusable() && this.isEnabled()) {
            Stroke stroke = g2.getStroke();
            g2.setStroke(new BasicStroke(3.0f));
            g2.setColor(this.animation.getColor("focus"));
            g2.drawOval(1, 1, this.getWidth() - 3, this.getHeight() - 3);
            g2.setStroke(stroke);
        }
    }

    private void updateColors() {
        String postfix = "";
        boolean mousePressed = this.model.isMousePressed();
        boolean mouseEntered = this.model.isMouseInside();
        boolean selected = this.model.isSelected();
        boolean enabled = this.model.isEnabled();
        if (enabled && mousePressed) {
            postfix = ".pressed";
        }
        if (enabled && mouseEntered && !mousePressed) {
            postfix = ".mouse";
        }
        if (selected) {
            postfix = postfix + ".selected";
        }
        if (enabled) {
            postfix = postfix + ".enabled";
        }
        String key = "action.button" + postfix;
        for (RoundActionColor color : this.colors) {
            if (!key.equals(color.getId())) continue;
            this.animation.putColor("button", (Color)color.value());
            break;
        }
        key = key + ".focus";
        for (RoundActionColor color : this.colors) {
            if (!key.equals(color.getId())) continue;
            this.animation.putColor("focus", (Color)color.value());
            break;
        }
    }

    private class RoundActionColor
    extends ActionColor {
        public RoundActionColor(String id, Dockable dockable, DockAction action, Color backup) {
            super(id, dockable, action, backup);
        }

        protected void changed(Color oldColor, Color newColor) {
            RoundButton.this.updateColors();
        }
    }
}

