/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock;

import bibliothek.extension.gui.dock.preference.PreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceTreeModel;
import bibliothek.extension.gui.dock.preference.model.BubbleThemePreferenceModel;
import bibliothek.extension.gui.dock.preference.model.ButtonContentPreferenceModel;
import bibliothek.extension.gui.dock.preference.model.EclipseThemePreferenceModel;
import bibliothek.extension.gui.dock.preference.model.KeyStrokePreferenceModel;
import bibliothek.extension.gui.dock.preference.model.LayoutPreferenceModel;
import bibliothek.gui.DockController;
import bibliothek.util.Path;
import bibliothek.util.PathCombiner;

public class DockingFramesPreference
extends PreferenceTreeModel {
    public DockingFramesPreference(DockController controller) {
        this(controller, PathCombiner.SECOND);
    }

    public DockingFramesPreference(DockController controller, PathCombiner combiner) {
        super(combiner, controller);
        this.putLinked(new Path("shortcuts"), "preference.shortcuts", new KeyStrokePreferenceModel(controller.getProperties()));
        this.putLinked(new Path("buttonContent"), "preference.buttonContent", new ButtonContentPreferenceModel(controller));
        this.putLinked(new Path("layout"), "preference.layout", new LayoutPreferenceModel(controller.getProperties()));
        this.putLinked(new Path("theme.BubbleTheme"), "theme.bubble", new BubbleThemePreferenceModel(controller.getProperties()));
        this.putLinked(new Path("theme.EclipseTheme"), "theme.eclipse", new EclipseThemePreferenceModel(controller.getProperties()));
    }

    public KeyStrokePreferenceModel getKeyStrokePreferences() {
        PreferenceModel model = this.getModel(new Path("shortcuts"));
        if (model instanceof KeyStrokePreferenceModel) {
            return (KeyStrokePreferenceModel)model;
        }
        throw new IllegalStateException("this model has been removed");
    }

    public LayoutPreferenceModel getLayoutPreferences() {
        PreferenceModel model = this.getModel(new Path("layout"));
        if (model instanceof LayoutPreferenceModel) {
            return (LayoutPreferenceModel)model;
        }
        throw new IllegalStateException("this model has been removed");
    }

    public ButtonContentPreferenceModel getButtonContent() {
        PreferenceModel model = this.getModel(new Path("buttonContent"));
        if (model instanceof ButtonContentPreferenceModel) {
            return (ButtonContentPreferenceModel)model;
        }
        throw new IllegalStateException("this model has been removed");
    }

    public BubbleThemePreferenceModel getBubbleThemePreferences() {
        PreferenceModel model = this.getModel(new Path("layout.BubbleTheme"));
        if (model instanceof BubbleThemePreferenceModel) {
            return (BubbleThemePreferenceModel)model;
        }
        throw new IllegalStateException("this model has been removed");
    }

    public EclipseThemePreferenceModel getEclipseThemePreferences() {
        PreferenceModel model = this.getModel(new Path("layout.EclipseTheme"));
        if (model instanceof EclipseThemePreferenceModel) {
            return (EclipseThemePreferenceModel)model;
        }
        throw new IllegalStateException("this model has been removed");
    }
}

