/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.dropdown;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.SelectableDockAction;
import bibliothek.gui.dock.action.dropdown.DropDownView;
import bibliothek.gui.dock.event.SelectableDockActionListener;
import bibliothek.gui.dock.themes.basic.action.dropdown.AbstractDropDownHandler;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JMenuItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectableDropDownHandler
extends AbstractDropDownHandler<SelectableDockAction> {
    private Listener listener = new Listener();

    public SelectableDropDownHandler(SelectableDockAction action, Dockable dockable, JMenuItem item) {
        super(action, dockable, item);
        item.addActionListener(this.listener);
    }

    @Override
    public void bind() {
        super.bind();
        boolean selected = ((SelectableDockAction)this.action).isSelected(this.dockable);
        this.item.setSelected(selected);
        ((SelectableDockAction)this.action).addSelectableListener(this.listener);
        if (this.getView() != null) {
            this.getView().setSelected(selected);
        }
    }

    @Override
    public void unbind() {
        ((SelectableDockAction)this.action).removeSelectableListener(this.listener);
        super.unbind();
    }

    @Override
    public void setView(DropDownView view) {
        super.setView(view);
        if (view != null) {
            view.setSelected(((SelectableDockAction)this.action).isSelected(this.dockable));
        }
    }

    protected void itemTriggered() {
        this.triggered();
    }

    @Override
    public void triggered() {
        ((SelectableDockAction)this.action).trigger(this.dockable);
        this.item.setSelected(((SelectableDockAction)this.action).isSelected(this.dockable));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Listener
    implements SelectableDockActionListener,
    ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((SelectableDockAction)SelectableDropDownHandler.this.action).isDropDownTriggerable(SelectableDropDownHandler.this.dockable, false)) {
                SelectableDropDownHandler.this.itemTriggered();
            } else {
                SelectableDropDownHandler.this.item.setSelected(((SelectableDockAction)SelectableDropDownHandler.this.action).isSelected(SelectableDropDownHandler.this.dockable));
            }
        }

        @Override
        public void selectedChanged(SelectableDockAction action, Set<Dockable> dockables) {
            if (dockables.contains(SelectableDropDownHandler.this.dockable)) {
                boolean selected = action.isSelected(SelectableDropDownHandler.this.dockable);
                if (SelectableDropDownHandler.this.getView() != null) {
                    SelectableDropDownHandler.this.getView().setSelected(selected);
                }
                SelectableDropDownHandler.this.item.setSelected(selected);
            }
        }
    }
}

