/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.action;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DefaultDockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.facile.action.RenameAction;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameActionFactory {
    private DockController controller;
    private Map<Class<?>, RenameAction> actions = new HashMap();

    public RenameActionFactory(DockController controller) {
        if (controller == null) {
            throw new IllegalArgumentException("Controller must not be null");
        }
        this.controller = controller;
    }

    public DockController getController() {
        return this.controller;
    }

    public RenameAction find(Dockable owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Owner must not be null");
        }
        Class<?> clazz = owner.getClass();
        RenameAction action = this.find(clazz);
        if (action == null) {
            throw new IllegalStateException("Can't find a rule for " + clazz.getName());
        }
        return action;
    }

    protected RenameAction find(Class<?> owner) {
        RenameAction action = this.actions.get(owner);
        if (action == null) {
            action = this.create(owner);
            if (action == null) {
                Class<?> superclass = owner.getSuperclass();
                if (superclass == null) {
                    return null;
                }
                action = this.find(superclass);
            }
            if (action != null) {
                this.actions.put(owner, action);
            }
        }
        return action;
    }

    protected RenameAction create(Class<?> owner) {
        if (owner.equals(DefaultDockable.class)) {
            return new RenameAction.RenameDefaultDockable(this.controller);
        }
        if (owner.equals(SplitDockStation.class)) {
            return new RenameAction.RenameSplitDockStation(this.controller);
        }
        if (owner.equals(FlapDockStation.class)) {
            return new RenameAction.RenameFlapDockStation(this.controller);
        }
        if (owner.equals(StackDockStation.class)) {
            return new RenameAction.RenameStackDockStation(this.controller);
        }
        return null;
    }
}

