/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.station.split;

import bibliothek.gui.dock.facile.station.split.ConflictResolver;
import bibliothek.gui.dock.facile.station.split.ResizeNode;
import bibliothek.gui.dock.facile.station.split.ResizeRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConflictResolver<T>
implements ConflictResolver<T> {
    private int increment(int i) {
        return i == -1 ? -1 : i + 1;
    }

    @Override
    public ResizeRequest requestHorizontal(ResizeRequest left, ResizeRequest right, ResizeNode<T> node) {
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return new ResizeRequest(right.getDeltaWidth(), right.getDeltaHeight(), this.increment(right.getFractionWidth()), right.getFractionHeight());
        }
        if (right == null) {
            return new ResizeRequest(left.getDeltaWidth(), left.getDeltaHeight(), this.increment(left.getFractionWidth()), left.getFractionHeight());
        }
        double widthDelta = 0.0;
        int widthFraction = -1;
        if (left.getFractionWidth() == -1 && right.getFractionWidth() == -1) {
            widthDelta = 0.0;
            widthFraction = -1;
        } else if (left.getFractionWidth() == -1) {
            widthDelta = right.getDeltaWidth();
            widthFraction = right.getFractionWidth() + 1;
        } else if (right.getFractionWidth() == -1) {
            widthDelta = left.getDeltaWidth();
            widthFraction = left.getFractionWidth() + 1;
        } else {
            widthDelta = left.getDeltaWidth() / (double)left.getFractionWidth() + right.getDeltaWidth() / (double)right.getFractionWidth() + node.getNewDividerSize() - node.getOldDividerSize();
            widthFraction = 1;
        }
        double heightDelta = 0.0;
        int heightFraction = -1;
        if (left.getFractionHeight() == -1 && right.getFractionHeight() == -1) {
            heightDelta = 0.0;
            heightFraction = -1;
        } else if (left.getFractionHeight() == -1) {
            heightDelta = right.getDeltaHeight();
            heightFraction = right.getFractionHeight();
        } else if (right.getFractionHeight() == -1) {
            heightDelta = left.getDeltaHeight();
            heightFraction = left.getFractionHeight();
        } else if (left.getFractionHeight() == right.getFractionHeight()) {
            heightDelta = (left.getDeltaHeight() + right.getDeltaHeight()) / 2.0;
            heightFraction = left.getFractionHeight();
        } else if (left.getFractionHeight() < right.getFractionHeight()) {
            heightDelta = left.getDeltaHeight();
            heightFraction = left.getFractionHeight();
        } else {
            heightDelta = right.getDeltaHeight();
            heightFraction = right.getFractionHeight();
        }
        if (widthFraction == -1 && heightFraction == -1) {
            return null;
        }
        return new ResizeRequest(widthDelta, heightDelta, widthFraction, heightFraction);
    }

    @Override
    public ResizeRequest requestVertical(ResizeRequest top, ResizeRequest bottom, ResizeNode<T> node) {
        if (top == null && bottom == null) {
            return null;
        }
        if (top == null) {
            return new ResizeRequest(bottom.getDeltaWidth(), bottom.getDeltaHeight(), bottom.getFractionWidth(), this.increment(bottom.getFractionHeight()));
        }
        if (bottom == null) {
            return new ResizeRequest(top.getDeltaWidth(), top.getDeltaHeight(), top.getFractionWidth(), this.increment(top.getFractionHeight()));
        }
        double widthDelta = 0.0;
        int widthFraction = -1;
        if (top.getFractionWidth() == -1 && bottom.getFractionWidth() == -1) {
            widthDelta = 0.0;
            widthFraction = -1;
        } else if (top.getFractionWidth() == -1) {
            widthDelta = bottom.getDeltaWidth();
            widthFraction = bottom.getFractionWidth();
        } else if (bottom.getFractionWidth() == -1) {
            widthDelta = top.getDeltaWidth();
            widthFraction = top.getFractionWidth();
        } else if (top.getFractionWidth() == bottom.getFractionWidth()) {
            widthDelta = (top.getDeltaWidth() + bottom.getDeltaWidth()) / 2.0;
            widthFraction = top.getFractionWidth();
        } else if (top.getFractionWidth() < bottom.getFractionWidth()) {
            widthDelta = top.getDeltaWidth();
            widthFraction = top.getFractionWidth();
        } else {
            widthDelta = bottom.getDeltaWidth();
            widthFraction = bottom.getFractionWidth();
        }
        double heightDelta = 0.0;
        int heightFraction = -1;
        if (top.getFractionHeight() == -1 && bottom.getFractionHeight() == -1) {
            heightDelta = 0.0;
            heightFraction = -1;
        } else if (top.getFractionHeight() == -1) {
            heightDelta = bottom.getDeltaHeight();
            heightFraction = bottom.getFractionHeight() + 1;
        } else if (bottom.getFractionHeight() == -1) {
            heightDelta = top.getDeltaHeight();
            heightFraction = top.getFractionHeight() + 1;
        } else {
            heightDelta = top.getDeltaHeight() / (double)top.getFractionHeight() + bottom.getDeltaHeight() / (double)bottom.getFractionHeight() + node.getNewDividerSize() - node.getOldDividerSize();
            heightFraction = 1;
        }
        if (widthFraction == -1 && heightFraction == -1) {
            return null;
        }
        return new ResizeRequest(widthDelta, heightDelta, widthFraction, heightFraction);
    }

    @Override
    public double resolveHorizontal(ResizeNode<T> node, ResizeRequest left, double deltaLeft, ResizeRequest right, double deltaRight) {
        if (left.getFractionWidth() == 1 && right.getFractionWidth() > 1) {
            return deltaLeft;
        }
        if (left.getFractionWidth() > 1 && right.getFractionWidth() == 1) {
            return deltaRight;
        }
        return (deltaLeft * (double)left.getFractionWidth() + deltaRight * (double)right.getFractionWidth()) / (double)(left.getFractionWidth() + right.getFractionWidth());
    }

    @Override
    public double resolveVertical(ResizeNode<T> node, ResizeRequest top, double deltaTop, ResizeRequest bottom, double deltaBottom) {
        if (top.getFractionHeight() == 1 && bottom.getFractionHeight() > 1) {
            return deltaTop;
        }
        if (top.getFractionHeight() > 1 && bottom.getFractionHeight() == 1) {
            return deltaBottom;
        }
        return (deltaTop * (double)top.getFractionHeight() + deltaBottom * (double)bottom.getFractionHeight()) / (double)(top.getFractionHeight() + bottom.getFractionHeight());
    }
}

