% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MI.resid.R
\name{MI.resid}
\alias{MI.resid}
\title{Moran Test for Residual Spatial Autocorrelation}
\usage{
MI.resid(
  resid,
  x = NULL,
  W,
  alternative = "greater",
  boot = NULL,
  na.rm = TRUE
)
}
\arguments{
\item{resid}{residual vector}

\item{x}{vector/ matrix of regressors (default = NULL)}

\item{W}{spatial connectivity matrix}

\item{alternative}{specification of alternative hypothesis as 'greater' (default),
'lower', or 'two.sided'}

\item{boot}{optional integer specifying the number of simulation iterations to
compute the variance. If NULL (default), variance calculated under assumed normality}

\item{na.rm}{listwise deletion of observations with missing values (TRUE/ FALSE)}
}
\value{
A \code{data.frame} object with the following elements:
\describe{
\item{\code{I}}{observed value of the Moran coefficient}
\item{\code{EI}}{expected value of Moran's I}
\item{\code{VarI}}{variance of Moran's I}
\item{\code{zI}}{standardized Moran coefficient}
\item{\code{pI}}{\emph{p}-value of the test statistic}
}
}
\description{
This function assesses the degree of spatial
autocorrelation present in regression residuals by means of the Moran
coefficient.
}
\details{
The function assumes an intercept-only model if \code{x = NULL}.
Furthermore, \code{MI.resid} automatically symmetrizes the matrix
\emph{\strong{W}} by: 1/2 * (\emph{\strong{W}} + \emph{\strong{W}}').
}
\note{
Calculations are based on the procedure proposed by Cliff and Ord
(1981). See also Cliff and Ord (1972).
}
\examples{
data(fakedata)
y <- fakedataset$x1
x <- fakedataset$x2

resid <- y - x \%*\% solve(crossprod(x)) \%*\% crossprod(x,y)
(Moran <- MI.resid(resid = resid, x = x, W = W, alternative = "greater"))

# intercept-only model
x <- rep(1, length(y))
resid2 <- y - x \%*\% solve(crossprod(x)) \%*\% crossprod(x,y)
intercept <- MI.resid(resid = resid2, W = W, alternative = "greater")
# same result with MI.vec for the intercept-only model
vec <- MI.vec(x = resid2, W = W, alternative = "greater")
rbind(intercept, vec)

}
\references{
Cliff, Andrew D. and John K. Ord (1981): Spatial Processes:
Models & Applications. Pion, London.

Cliff, Andrew D. and John K. Ord (1972): Testing for Spatial Autocorrelation
Among Regression Residuals. Geographical Analysis, 4 (3): pp. 267 - 284
}
\seealso{
\code{\link{lmFilter}}, \code{\link{glmFilter}}, \code{\link{MI.vec}},
\code{\link{MI.local}}
}
\author{
Sebastian Juhl
}
