% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_render.r
\name{array2df}
\alias{array2df}
\title{Turns a tour path array into a long data frame}
\usage{
array2df(array, data = NULL, lab = NULL)
}
\arguments{
\item{array}{A (p, d, n_slides) array of a tour, the output of
\code{manual_tour()}.}

\item{data}{Optional, (n, p) dataset to project, consisting of numeric
variables.}

\item{lab}{Optional, labels for the reference frame of length 1 or the
number of variables used. Defaults to an abbreviation of the variables.}
}
\value{
A list containing the (p, d, n_slides) basis slides array, and
the (n, d, n_slides) data slides array.
}
\description{
Typically called by a wrapper function, \code{play_manual_tour} or
\code{play_tour_path}. Takes the result of \code{tourr::save_history()} or
\code{manual_tour()} and restructures the data from an array to a long data frame
for use in ggplots.
}
\examples{
flea_std <- tourr::rescale(tourr::flea[, 1:6])

rb <- tourr::basis_random(n = ncol(flea_std))
mtour <- manual_tour(basis = rb, manip_var = 4)
array2df(array = mtour, data = flea_std)
}
