% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spinifex-package.r
\docType{package}
\name{spinifex}
\alias{spinifex}
\alias{spinifex-package}
\title{spinifex}
\description{
spinifex is a package that extends the package \code{tourr}.
It builds the functionality for manual tours and allows other
tours to be rendered by \code{plotly} or \code{gganimate}. Tours are a class of
dynamic linear (orthogonal) projections of numeric multivariate data from
\code{p} down to \code{d} dimensions that are viewed as an animation as \code{p}-space is
rotated. Manual tours manipulate a selected variable, exploring how they
contribute to the sensitivity of the structure in the projection. This is
particularly useful after finding an interesting tour, perhaps via a
guided tour.
}
\details{
Its main functions are:
\itemize{
\item \code{\link[=run_app]{run_app()}}, running \code{run_app("intro")} will open an introductory \code{shiny} app demonstrating radial tours.
\item \code{\link[=play_manual_tour]{play_manual_tour()}}, performs a manual tour, returning a \code{plotly} animate by default.
\item \code{\link[=play_tour_path]{play_tour_path()}}, turns a tour path into an animation, returning a \code{plotly} object by default.
\item \code{\link[=view_basis]{view_basis()}}, plot a basis set on a reference axis.
\item \code{\link[=view_manip_space]{view_manip_space()}}, plot a manipulation space highlighting the manip var.
}

GitHub: \url{https://github.com/nspyrison/spinifex}
}
\seealso{
tourr (package)
}
\author{
\strong{Maintainer}: Nicholas Spyrison \email{spyrison@gmail.com}

Authors:
\itemize{
  \item Dianne Cook [thesis advisor]
}

}
