% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_util.r
\name{as_history_array}
\alias{as_history_array}
\title{Changes an array of bases into a "history_array" class for use
in \code{tourr::interpolate()}.}
\usage{
as_history_array(basis_array, data = NULL)
}
\arguments{
\item{basis_array}{An array of bases.}

\item{data}{The data matrix to be projected through the basis. This is
\code{tourr::save_history} objects, but not consumed downstream in \code{spinifex}.}
}
\value{
An array of numeric bases with custom class "history_array" for
consumption by \code{tourr::interpolate}.
}
\description{
Internal function, many end users will not need this. Attaches data to an array and assigns the custom class "history_array" as
used in \code{tourr}. Typically called by basis arrays from \code{spinifex} functions.
}
\examples{
## !!This function is not meant for external use!!
dat_std <- scale_sd(wine[, 2:6])
bas <- basis_pca(dat_std)
mv <- manip_var_of(bas)
mt_array <- manual_tour(basis = bas, manip_var = mv)
as_history_array(mt_array, dat_std)
}
\seealso{
\code{\link[tourr:save_history]{tourr::save_history}} for preset choices.
}
