% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spiro_max.R
\name{spiro_max}
\alias{spiro_max}
\title{Return maximum values from cardiopulmonary exercise tests}
\usage{
spiro_max(data, smooth = 30, hr_smooth = FALSE)
}
\arguments{
\item{data}{A \code{data.frame} of the class \code{spiro} containing the gas
exchange data. Usually the output of a \code{\link{spiro}} call.}

\item{smooth}{Parameter giving the filter methods for smoothing the data.
Default is \code{30} for a 30-second moving average. \code{"20b"} will
apply a 20-breath averaging for example. See \code{\link{spiro_smooth}} for
further details and filter methods (e.g. Butterworth filters).}

\item{hr_smooth}{A logical, whether smoothing should also apply to heart rate
data. Default is \code{FALSE}, which means that the absolute maximum heart rate
value is taken without smoothing.}
}
\value{
A \code{data.frame} with the maximum parameter values of the data.
}
\description{
\code{spiro_max()} returns a \code{data.frame} with the maximum gas exchange
parameters of an exercise test.
}
\details{
Before calculating the maximum values, the raw data is smoothed. Default
smoothing method is a 30-second rolling average. See the \code{smooth}
argument in \code{\link{spiro_smooth}} for more options, such as breath-based
averages or digital filtering.

Parameters calculated are the maxima of oxygen uptake (absolute and
relative), carbon dioxide output, minute ventilation, respiratory exchange
ratio (RER), and heart rate. The maximum values are defined as the highest
single data values after the smoothing.

For the maximum RER a different algorithm is used, as the RER during and
after rest may exceed the peak value during exercise. Therefore only values
during the last ten percent of the exercise time are considered for the
RERmax determination. The RERmax calculation works best for data from tests
without rest intervals (e.g., ramp tests) and with attached load protocol
data.
}
\examples{
# Import and process example data sets
gxt_data <- spiro(file = spiro_example("zan_gxt"))

spiro_max(gxt_data)

# Use an averaging over a time interval of 15 seconds
spiro_max(gxt_data, smooth = 15)

# Use an averaging over an interval of 15 breaths
spiro_max(gxt_data, smooth = "15b")
}
