% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update}
\alias{update}
\alias{update.bSpline2}
\alias{update.dbs}
\alias{update.ibs}
\alias{update.mSpline}
\alias{update.iSpline}
\alias{update.cSpline}
\alias{update.bernsteinPoly}
\alias{update.naturalSpline}
\title{Update Spline Basis Functions}
\usage{
\method{update}{bSpline2}(object, ...)

\method{update}{dbs}(object, ...)

\method{update}{ibs}(object, ...)

\method{update}{mSpline}(object, ...)

\method{update}{iSpline}(object, ...)

\method{update}{cSpline}(object, ...)

\method{update}{bernsteinPoly}(object, ...)

\method{update}{naturalSpline}(object, ...)
}
\arguments{
\item{object}{Objects of class \code{bSpline2}, \code{ibs}, \code{mSpline},
\code{iSpline}, \code{cSpline}, \code{bernsteinPoly} or
\code{naturalSpline} with attributes describing \code{knots},
\code{degree}, etc.}

\item{...}{Other arguments passed to the corresponing constructor function.}
}
\value{
An updated object of the same class as the input object with the
    specified updates.
}
\description{
Update the knot placement, polynomial degree, and any other options
available when constructing the given spline object.
}
\examples{
library(splines2)

x <- seq.int(0, 1, 0.01)
knots <- c(0.3, 0.5, 0.6)

## quadratic B-splines
bsMat2 <- bSpline(x, knots = knots, degree = 2, intercept = TRUE)

## cubic B-splines
bsMat3 <- update(bsMat2, degree = 3)
}
