% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm12_slice_timing.R
\name{spm12_slice_timing.deprecated}
\alias{spm12_slice_timing.deprecated}
\title{SPM12 Slice Timing Correction}
\usage{
spm12_slice_timing.deprecated(
  filename,
  time_points = NULL,
  nslices,
  tr,
  ta = tr - tr/nslices,
  slice_order = 1:nslices,
  ref_slice,
  prefix = "a",
  add_spm_dir = TRUE,
  spmdir = spm_dir(verbose = verbose, install_dir = NULL),
  clean = TRUE,
  verbose = TRUE,
  outdir = tempdir(),
  retimg = FALSE,
  reorient = FALSE,
  install_dir = NULL,
  ...
)
}
\arguments{
\item{filename}{Files to be slice-time corrected}

\item{time_points}{Time points to run slice-time correction.
If \code{filename} is a
4D file, then will do all the time points.  Otherwise, 
\code{filename} must be a character
vector of 3D files or a list of 3D nifti objects.}

\item{nslices}{Number of slices in the images}

\item{tr}{Repetition time (in seconds)}

\item{ta}{Time between the first and the last slice 
within one scan}

\item{slice_order}{Order slices were taken (if not specified, 
assumed ascending),
bottom slice = 1}

\item{ref_slice}{Reference slice}

\item{prefix}{Prefix to append to front of image filename}

\item{add_spm_dir}{Add SPM12 directory from this package}

\item{spmdir}{SPM dir to add, will use package default directory}

\item{clean}{Remove scripts from temporary directory 
after running}

\item{verbose}{Print diagnostic messages}

\item{outdir}{Directory to copy results}

\item{retimg}{(logical) return image of class nifti}

\item{reorient}{(logical) If retimg, should file be 
reoriented when read in?
Passed to \code{\link{readNIfTI}}.}

\item{install_dir}{directory to download SPM12}

\item{...}{Arguments passed to \code{\link{run_spm12_script}}}
}
\value{
Output filenames
}
\description{
Performs SPM12 slice timing correction on images
}
