% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy.spmod}
\alias{tidy.spmod}
\title{Tidy a fitted model object}
\usage{
\method{tidy}{spmod}(x, conf.int = FALSE, conf.level = 0.95, effects = "fixed", ...)
}
\arguments{
\item{x}{A fitted model object from \code{\link[=splm]{splm()}} or \code{\link[=spautor]{spautor()}}}

\item{conf.int}{Logical indicating whether or not to include a confidence interval
in the tidied output. The default is \code{FALSE}.}

\item{conf.level}{The confidence level to use for the confidence interval if
\code{conf.int} is \code{TRUE}. Must be strictly greater than 0 and less than 1.
The default is 0.95, which corresponds to a 95 percent confidence interval.}

\item{effects}{The type of effects to tidy. Available options are \code{"fixed"}
(fixed effects), \code{"spcov"} (spatial covariance parameters),
and \code{"randcov"} (random effect variances). The default is \code{"fixed"}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
A tidy tibble of summary information \code{effects}.
}
\description{
Tidy a fitted model object into a summarized tibble.
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
tidy(spmod)
tidy(spmod, effects = "spcov")
}
\seealso{
\code{\link[=glance.spmod]{glance.spmod()}} \code{\link[=augment.spmod]{augment.spmod()}}
}
