% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html.R
\name{as_html.spar}
\alias{as_html.spar}
\title{Convert One Spork to Html}
\usage{
\method{as_html}{spar}(
  x,
  newline = getOption("html_newline", "<br/>"),
  unrecognized = getOption("html_unrecognized", "htmlToken"),
  token_open = getOption("html_token_open", ""),
  token_close = getOption("html_token_close", ""),
  math_open = getOption("html_math_open", ""),
  math_close = getOption("html_math_close", ""),
  label_open = getOption("html_label_open", ""),
  label_close = getOption("html_label_close", ""),
  ...
)
}
\arguments{
\item{x}{spar}

\item{newline}{value to replace \code{'\\n'}}

\item{unrecognized}{function to process unrecognized tokens: default \code{\link{htmlToken}}}

\item{token_open, token_close}{these wrap text-like portions of the label; the defaults try to give upright characters (non-italic); also passed to \code{\link{htmlToken}}}

\item{math_open, math_close}{these wrap math-like portions of the label;  the defaults try to give upright characters (non-italic) which may not work for Greek symbols; also passed to \code{\link{htmlToken}}}

\item{label_open, label_close}{these wrap the entire label}

\item{...}{passed to \code{unrecognized}; see \code{\link{htmlToken}}}
}
\value{
html
}
\description{
Converts one spork to html.
See description for \code{\link{as_spork}}.
By default, unrecognized tokens are returned
literally.  However, Greek symbols and html
metacharacters are escaped.
See \code{\link{htmlToken}}.
}
\details{
Experimental support is implemented for
the newline character (\code{'\\n'}).
Default behavior is to introduce linebreaks
(<br/>) into the resulting
html.
}
\examples{
library(magrittr)
'V_c./F' \%>\% as_spork \%>\% as_html
'AUC_ss' \%>\% as_spork \%>\% as_html
'C_max_ss' \%>\% as_spork \%>\% as_html
'var^eta_j' \%>\% as_spork \%>\% as_html
'& < \% $ # \\\\_ { } ~ \\\\^ \\\\' \%>\% as_spork \%>\% as_html
'one joule (Omega) ~ 1 kg*m^2./s^2' \%>\% as_spork \%>\% as_html
}
\seealso{
Other interface: 
\code{\link{as.expression.plotmath}()},
\code{\link{as_html.spork}()},
\code{\link{as_latex.default}()},
\code{\link{as_latex.spar}()},
\code{\link{as_latex.spork}()},
\code{\link{as_plotmath.spar}()},
\code{\link{as_plotmath.spork}()},
\code{\link{as_previews.spork}()},
\code{\link{as_spork.character}()},
\code{\link{htmlToken}()},
\code{\link{latexToken}()},
\code{\link{plotmathToken}()}

Other html: 
\code{\link{[.html}()},
\code{\link{[[.html}()},
\code{\link{as_html.spork}()},
\code{\link{as_html}()},
\code{\link{htmlToken}()}
}
\concept{html}
\concept{interface}
