% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sport-basketball.R
\name{geom_basketball}
\alias{geom_basketball}
\title{Create a ggplot2 instance of a scale model of a basketball court}
\usage{
geom_basketball(
  league,
  full_surf = TRUE,
  rotate = FALSE,
  rotation_dir = "ccw",
  ...
)
}
\arguments{
\item{league}{The league for which to draw the surface}

\item{full_surf}{A boolean indicating whether or not to plot a full surface
representation of the surface. Default: \code{TRUE}}

\item{rotate}{A boolean indicating whether or not this feature needs to be
rotated. Default: \code{FALSE}}

\item{rotation_dir}{A string indicating which direction to rotate the
feature. Default: \code{'ccw'}}

\item{...}{Additional arguments to pass to the function. These should be the
colors to pass to the \code{mlb_features_set_colors()} function, or units
with which to draw the plot}
}
\value{
A ggplot2 instance with a full-surface representation of a basketball
court
}
\description{
Create a ggplot2 instance of a scale model of a basketball court
}
\examples{
geom_basketball(league = "NBA")
geom_basketball(league = "NCAA", full_surf = FALSE)
geom_basketball(league = "FIBA", rotate = TRUE, rotation_dir = "ccw")
}
