% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features-football.R
\name{football_field_border}
\alias{football_field_border}
\title{The field border is the border line around the outer edge of the sideline and
end line. They may not be present on every field, but this is not the same as
the sideline or end line (although they may be the same color)}
\usage{
football_field_border(
  field_length = 0,
  field_width = 0,
  feature_thickness = 0,
  endzone_length = 0,
  boundary_line_thickness = 0,
  restricted_area_length = 0,
  restricted_area_width = 0,
  coaching_box_length = 0,
  coaching_box_width = 0,
  team_bench_length_field_side = 0,
  team_bench_length_back_side = 0,
  team_bench_width = 0,
  team_bench_area_border_thickness = 0,
  surrounds_team_bench_area = FALSE,
  bench_shape = ""
)
}
\arguments{
\item{field_length}{The length of the field}

\item{field_width}{The width of the field}

\item{feature_thickness}{The thickness of the field border}

\item{endzone_length}{The length of the endzone}

\item{boundary_line_thickness}{The thickness of the boundary lines}

\item{restricted_area_length}{The length of the restricted area}

\item{restricted_area_width}{The width of the restricted area}

\item{coaching_box_length}{The length of the coaching box}

\item{coaching_box_width}{The width of the coaching box}

\item{team_bench_length_field_side}{The length of the side of the team bench
closest to the field}

\item{team_bench_length_back_side}{The length of the side of the team bench
furthest from the field}

\item{team_bench_width}{The width of the team bench}

\item{team_bench_area_border_thickness}{The thickness of the border around
the team bench}

\item{surrounds_team_bench_area}{A boolean of whether or not the field border
should surround the team bench}

\item{bench_shape}{A string of the shape of the bench. Currently, this checks
for \code{"rectangle"}}
}
\value{
A data frame of the bounding box of the field border
}
\description{
The field border is the border line around the outer edge of the sideline and
end line. They may not be present on every field, but this is not the same as
the sideline or end line (although they may be the same color)
}
\keyword{internal}
