% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normmix_plots.R
\name{plot_true_labels}
\alias{plot_true_labels}
\title{Plot the true membership indicators}
\usage{
plot_true_labels(pattern, open_new_window = FALSE)
}
\arguments{
\item{pattern}{Object of class \code{sppmix}.}

\item{open_new_window}{Open a new window for the plot.}
}
\description{
The function plots the true membership
indicators (or allocation variables)
of each point to one of the mixture components,
based on a generated \code{sppmix} object.
These are the true probabilities
of a point belonging to a component.

For examples see

\url{http://www.stat.missouri.edu/~amicheas/sppmix/sppmix_all_examples.html
#plot_true_labels}
}
\examples{

\dontrun{
truemix <- rnormmix(m = 5, sig0 = .1, df = 5, xlim= c(-3, 3), ylim = c(-3, 3))
intsurf=to_int_surf(truemix, lambda = 100, win =spatstat::owin( c(-3, 3),c(-3, 3)))
pp1 <- rsppmix(intsurf,FALSE)
plot_true_labels(pp1)}

}
\author{
Sakis Micheas
}
\seealso{
\code{\link{rnormmix}},
\code{\link{to_int_surf}},
\code{\link[spatstat]{owin}},
\code{\link{rsppmix}}
}

