% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normmix_plots.R
\name{plot2dPP}
\alias{plot2dPP}
\title{Plot a spatial point pattern}
\usage{
plot2dPP(pp, mus, add2plot = FALSE, title1 = "Spatial point pattern",
  open_new_window = FALSE)
}
\arguments{
\item{pp}{A point pattern of class sppmix or
\code{\link[spatstat]{ppp}}.}

\item{mus}{An optional list of the theoretical means of the mixture components.}

\item{add2plot}{Logical variable to indicate if the function should add the points to an existing plot.}

\item{title1}{Title for the plot.}

\item{open_new_window}{Open a new window for the plot.}
}
\description{
Standard 2d plot for a spatial point pattern.

For examples see

\url{http://faculty.missouri.edu/~micheasa/sppmix/sppmix_all_examples.html
#plot2dPP}
}
\examples{
\donttest{
mix1 <- rnormmix(5, sig0 = .01, df = 5, xlim=c(0, 5), ylim=c(0, 5))
intsurf1=to_int_surf(mix1, lambda = 40, win =spatstat::owin( c(0, 5),c(0, 5)))
pp1 <- rsppmix(intsurf1)
plot2dPP(pp1)
plot2dPP(pp1, mus = intsurf1$mus)}

}
\seealso{
\code{\link{normmix}},
\code{\link{to_int_surf}},
\code{\link[spatstat]{owin}},
\code{\link{rsppmix}}
}
\author{
Sakis Micheas
}
