% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimSPAN.R
\name{optimSPAN}
\alias{SPAN}
\alias{objSPAN}
\alias{optimSPAN}
\title{Optimization of sample configurations for variogram and spatial trend identification and estimation, and 
for spatial interpolation}
\usage{
optimSPAN(points, candi, covars, strata.type = "area", use.coords = FALSE,
  lags = 7, lags.type = "exponential", lags.base = 2, cutoff,
  criterion = "distribution", distri, pairs = FALSE,
  schedule = scheduleSPSANN(), plotit = FALSE, track = FALSE, boundary,
  progress = "txt", verbose = FALSE, weights = list(CORR = 1/6, DIST =
  1/6, PPL = 1/3, MSSD = 1/3), nadir = list(sim = NULL, seeds = NULL, user =
  NULL, abs = NULL), utopia = list(user = NULL, abs = NULL))

objSPAN(points, candi, covars, strata.type = "area", use.coords = FALSE,
  lags = 7, lags.type = "exponential", lags.base = 2, cutoff,
  criterion = "distribution", distri, pairs = FALSE, x.max, x.min, y.max,
  y.min, weights = list(CORR = 1/6, DIST = 1/6, PPL = 1/3, MSSD = 1/3),
  nadir = list(sim = NULL, seeds = NULL, user = NULL, abs = NULL),
  utopia = list(user = NULL, abs = NULL))
}
\arguments{
\item{points}{Integer value, integer vector, data frame or matrix. If \code{points} is an integer value, 
it defines the number of points that should be randomly sampled from \code{candi} to form the starting 
system configuration. If \code{points} is a vector of integer values, it contains the row indexes of 
\code{candi} that correspond to the points that form the starting system configuration. If \code{points} 
is a data frame or matrix, it must have three columns in the following order: \code{[, "id"]} the row 
indexes of \code{candi} that correspond to each point, \code{[, "x"]} the projected x-coordinates, and 
\code{[, "y"]} the projected y-coordinates. Note that in the later case, \code{points} must be a subset 
of \code{candi}.}

\item{candi}{Data frame or matrix with the candidate locations for the jittered points. \code{candi} must 
have two columns in the following order: \code{[, "x"]} the projected x-coordinates, and \code{[, "y"]} the 
projected y-coordinates.}

\item{covars}{Data frame or matrix with the covariates in the columns.}

\item{strata.type}{Character value setting the type of stratification that should be used to create the 
marginal sampling strata (or factor levels) for the numeric covariates. Available options are \code{"area"},
for equal-area, and \code{"range"}, for equal-range. Defaults to \code{strata.type = "area"}.}

\item{use.coords}{Logical value. Should the geographic coordinates be used as covariates? Defaults to 
\code{use.coords = FALSE}.}

\item{lags}{Integer value, the number of lag-distance classes. Alternatively, a vector of numeric values 
with the lower and upper bounds of each lag-distance class, the lowest value being larger than zero 
(e.g. 0.0001). Defaults to \code{lags = 7}.}

\item{lags.type}{Character value, the type of lag-distance classes, with options \code{"equidistant"} and
\code{"exponential"}. Defaults to \code{lags.type = "exponential"}.}

\item{lags.base}{Numeric value, base of the exponential expression used to create exponentially spaced 
lag-distance classes. Used only when \code{lags.type = "exponential"}. Defaults to \code{lags.base = 2}.}

\item{cutoff}{Numeric value, the maximum distance up to which lag-distance classes are created. Used only
when \code{lags} is an integer value. If missing, it is set to be equal to the length of the diagonal of 
the rectagle with sides \code{x.max} and \code{y.max} as defined in \code{\link[spsann]{scheduleSPSANN}}.}

\item{criterion}{Character value, the feature used to describe the energy state of the system 
configuration, with options \code{"minimum"} and \code{"distribution"}. Defaults to 
\code{objective = "distribution"}.}

\item{distri}{Numeric vector, the distribution of points or point-pairs per lag-distance class that should 
be attained at the end of the optimization. Used only when \code{criterion = "distribution"}. Defaults to 
a uniform distribution.}

\item{pairs}{Logical value. Should the sample configuration be optimized regarding the number of 
point-pairs per lag-distance class? Defaults to \code{pairs = FALSE}.}

\item{schedule}{List with 11 named sub-arguments defining the control parameters of the cooling schedule. 
See \code{\link[spsann]{scheduleSPSANN}}.}

\item{plotit}{Logical for plotting the optimization results, including a) the progress of the objective
function, and b) the starting (gray) and current system configuration (black), and the maximum jitter in 
the x- and y-coordinates. The plots are updated at each 10 jitters. Defaults to \code{plotit = FALSE}.}

\item{track}{Logical value. Should the evolution of the energy state be recorded and returned with the 
result? If \code{track = FALSE} (the default), only the starting and ending energy states are returned with
the results.}

\item{boundary}{SpatialPolygon defining the boundary of the spatial domain. If missing and 
\code{plotit = TRUE}, \code{boundary} is estimated from \code{candi}.}

\item{progress}{Type of progress bar that should be used, with options \code{"txt"}, for a text progress 
bar in the R console, \code{"tk"}, to put up a Tk progress bar widget, and \code{NULL} to omit the progress
bar. A Tk progress bar widget is useful when using parallel processors. Defaults to 
\code{progress = "txt"}.}

\item{verbose}{Logical for printing messages about the progress of the optimization. Defaults to 
\code{verbose = FALSE}.}

\item{weights}{List with named sub-arguments. The weights assigned to each one of the objective functions
that form the multi-objective combinatorial optimization problem. They must be named after the respective 
objective function to which they apply. The weights must be equal to or larger than 0 and sum to 1. The 
default option gives equal weights to all objective functions.}

\item{nadir}{List with named sub-arguments. Three options are available: 1) \code{sim} -- the number of 
simulations that should be used to estimate the nadir point, and \code{seeds} -- vector defining the random
seeds for each simulation; 2) \code{user} -- a list of user-defined nadir values named after the respective
objective functions to which they apply; 3) \code{abs} -- logical for calculating the nadir point 
internally (experimental).}

\item{utopia}{List with named sub-arguments. Two options are available: 1) \code{user} -- a list of 
user-defined values named after the respective objective functions to which they apply; 2) \code{abs} --
logical for calculating the utopia point internally (experimental).}

\item{x.max, x.min, y.max, y.min}{Numeric value defining the minimum and maximum quantity of random noise to 
be added to the projected x- and y-coordinates. The minimum quantity should be equal to, at least, the 
minimum distance between two neighbouring candidate locations. The units are the same as of the projected 
x- and y-coordinates. If missing, they are estimated from \code{candi}.}
}
\value{
\code{optimSPAN} returns an object of class \code{OptimizedSampleConfiguration}: the optimized sample
configuration with details about the optimization.

\code{objSPAN} returns a numeric value: the energy state of the sample configuration -- the objective
function value.
}
\description{
Optimize a sample configuration for variogram and spatial trend identification and estimation, and for 
spatial interpolation. An utility function \emph{U} is defined so that the sample points cover, extend 
over, spread over, \bold{SPAN} the feature, variogram and geographic spaces. The utility function is 
obtained aggregating four objective functions: \bold{CORR}, \bold{DIST}, \bold{PPL}, and \bold{MSSD}.
}
\details{
The help page of \code{\link[spsann]{minmaxPareto}} contains details on how \pkg{spsann} solves the
multi-objective combinatorial optimization problem of finding a globally optimum sample configuration that
meets multiple conflicting objectives.

Details about the mechanism used to generate a new sample configuration out of the current sample 
configuration by randomly perturbing the coordinates of a sample point are available in the help page of
\code{\link[spsann]{spJitter}}.

Visit the help pages of \code{\link[spsann]{optimCORR}}, \code{\link[spsann]{optimDIST}},
\code{\link[spsann]{optimPPL}}, and \code{\link[spsann]{optimMSSD}} to see the details of the objective
functions that compose \bold{SPAN}.
}
\note{
The distance between two points is computed as the Euclidean distance between them. This computation 
assumes that the optimization is operating in the two-dimensional Euclidean space, i.e. the coordinates of
the sample points and candidate locations should not be provided as latitude/longitude. \pkg{spsann} has no 
mechanism to check if the coordinates are projected: the user is responsible for making sure that this
requirement is attained.
}
\examples{
\dontrun{
# This example takes more than 5 seconds to run!
require(sp)
data(meuse.grid)
candi <- meuse.grid[, 1:2]
nadir <- list(sim = 10, seeds = 1:10)
utopia <- list(user = list(DIST = 0, CORR = 0, PPL = 0, MSSD = 0))
covars <- meuse.grid[, 5]
schedule <- scheduleSPSANN(chains = 1, initial.temperature = 1,
                           x.max = 1540, y.max = 2060, x.min = 0, 
                           y.min = 0, cellsize = 40)
set.seed(2001)
res <- optimSPAN(points = 10, candi = candi, covars = covars, nadir = nadir,
                 use.coords = TRUE, utopia = utopia, schedule = schedule)
objSPSANN(res) -
  objSPAN(points = res, candi = candi, covars = covars, nadir = nadir,
          use.coords = TRUE, utopia = utopia)
}
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
\seealso{
\code{\link[spsann]{optimCORR}}, \code{\link[spsann]{optimDIST}}, \code{\link[spsann]{optimPPL}},
\code{\link[spsann]{optimMSSD}}
}
\concept{
simulated annealing

spatial trend

variogram
}
\keyword{iteration}
\keyword{optimize}
\keyword{spatial}

