% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcdfvar.total.R
\name{dcdfvar.total}
\alias{dcdfvar.total}
\title{Variance Estimate of Deconvoluted CDF for Total}
\usage{
dcdfvar.total(g, dg, var.sigma, wgt, x, y, cdfest, stratum.ind,
  stratum.level, cluster.ind, cluster, wgt1, x1, y1, popsize, pcfactor.ind,
  pcfsize, N.cluster, stage1size, support, vartype, warn.ind, warn.df,
  warn.vec)
}
\arguments{
\item{g}{Vector of the values of the deconvolution function g(.) evaluated
at a specified value for the response value for each site.}

\item{dg}{Vector of the derivative of the deconvolution function g(.)
evaluated at val for the response value for each site.}

\item{var.sigma}{Variance of the measurement error variance.}

\item{wgt}{Vector of the final adjusted weight (inverse of the sample
inclusion probability) for each site, which is either the weight for a
single- stage sample or the stage two weight for a two-stage sample.}

\item{x}{Vector of x-coordinate for location for each site, which is either
the x-coordinate for a single-stage sample or the stage two x-coordinate
for a two-stage sample.}

\item{y}{Vector of y-coordinate for location for each site, which is either
the y-coordinate for a single-stage sample or the stage two y-coordinate
for a two-stage sample.}

\item{cdfest}{The CDF estimate.}

\item{stratum.ind}{Logical value that indicates whether the sample is
stratified, where TRUE = a stratified sample and FALSE = not a stratified
sample.}

\item{stratum.level}{The stratum level.}

\item{cluster.ind}{Logical value that indicates whether the sample is a
two- stage sample, where TRUE = a two-stage sample and FALSE = not a
two-stage sample.}

\item{cluster}{Vector of the stage one sampling unit (primary sampling unit
or cluster) code for each site.}

\item{wgt1}{Vector of the final adjusted stage one weight for each site.}

\item{x1}{Vector of the stage one x-coordinate for location for each site.}

\item{y1}{Vector of the stage one y-coordinate for location for each site.}

\item{popsize}{Known size of the resource, which is used to perform ratio
adjustment to estimators expressed using measurement units for the
resource.  For a finite resource, this argument is either the total number
of sampling units or the known sum of size-weights.  For an extensive
resource, this argument is the measure of the resource, i.e., either known
total length for a linear resource or known total area for an areal
resource.  For a stratified sample this variable must be a vector
containing a value for each stratum and must have the names attribute set
to identify the stratum codes.}

\item{pcfactor.ind}{Logical value that indicates whether the population
correction factor is used during variance estimation, where TRUE = use the
population correction factor and FALSE = do not use the factor.  To employ
the correction factor for a single-stage sample, values must be supplied
for arguments pcfsize and support.  To employ the correction factor for a
two-stage sample, values must be supplied for arguments N.cluster,
stage1size, and support.}

\item{pcfsize}{Size of the resource, which is required for calculation of
finite and continuous population correction factors for a single-stage
sample. For a stratified sample this argument must be a vector containing a
value for each stratum and must have the names attribute set to identify
the stratum codes.}

\item{N.cluster}{The number of stage one sampling units in the resource,
which is required for calculation of finite and continuous population
correction factors for a two-stage sample.  For a stratified sample this
variable must be a vector containing a value for each stratum and must have
the names attribute set to identify the stratum codes.}

\item{stage1size}{Size of the stage one sampling units of a two-stage
sample, which is required for calculation of finite and continuous
population correction factors for a two-stage sample and must have the
names attribute set to identify the stage one sampling unit codes.  For a
stratified sample, the names attribute must be set to identify both stratum
codes and stage one sampling unit codes using a convention where the two
codes are separated by the & symbol, e.g., "Stratum 1&Cluster 1".}

\item{support}{Vector of the support value for each site - the value one
(1) for a site from a finite resource or the measure of the sampling unit
associated with a site from a continuous resource, which is required for
calculation of finite and continuous population correction factors.}

\item{vartype}{The choice of variance estimator, where "Local" = local mean
estimator and "SRS" = SRS estimator.}

\item{warn.ind}{Logical value that indicates whether warning messages were
generated, where TRUE = warning messages were generated and FALSE = warning
messages were not generated.}

\item{warn.df}{Data frame for storing warning messages.}

\item{warn.vec}{Vector that contains names of the population type, the
subpopulation, and an indicator.}
}
\value{
An object in list format composed of a vector named varest, which
  contains variance estimates, a logical variable named warn,ind, which is
  the indicator for warning messges, and a data frame named warn.df, which
}
\description{
This function calculates variance estimates of the estimated, deconvoluted
cumulative distribution function (CDF) for the total of a discrete or a
continuous resource.  Either the simple random sampling (SRS) variance
estimator or the local mean variance estimator is calculated, which is
subject to user control.  The SRS variance estimator uses the independent
random sample approximation to calculate joint inclusion probabilities. When
variance of the estimated measurement error variance is nonzero, a correction
factor is added to the estimated variance of the CDF.  The function can
accomodate single-stage and two-stage samples.  Finite population and
continuous population correction factors can be utilized in variance
estimation.
}
\section{Other Functions Required}{

  \describe{
    \item{\code{\link{localmean.weight}}}{calculate the weighting matrix for
      the local mean variance estimator}
    \item{\code{\link{localmean.var}}}{calculate the local mean variance
      estimator}
  }
}

\author{
Tom Kincaid \email{Kincaid.Tom@epa.gov}
}
\keyword{survey}
