% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCRM.R
\name{makeCRM}
\alias{makeCRM}
\alias{makecrm}
\title{Defining a spatial correlogram model}
\usage{
makeCRM(acf0 = 1, range = NA, model, anis, kappa = 0.5, add.to, covtable,
  Err = 0)
}
\arguments{
\item{acf0}{Aurocorrelation function value at distance near 0. Default is 1. Must
fall in interval [0,1].}

\item{range}{Range parameter of the correlogram model component.}

\item{model}{Model type, e.g. "Exp", "Sph", "Gau", "Mat" that vgm() accepts. See ?gstat::vgm() for more #' details.}

\item{anis}{Anisotropy parameters. See ?gstat::vgm() for more details.}

\item{kappa}{Smoothness parameter for the Matern class of variogram models. See ?gstat::vgm() for more #' details.}

\item{add.to}{See ?gstat::vgm() (currently not in use)}

\item{covtable}{See ?gstat::vgm() (currently not in use)}

\item{Err}{Numeric. See ?gstat::vgm() for more details.}
}
\value{
An object of a class "SpatialCorrelogramModel". This is a list collating provided arguments.
}
\description{
Function that generates a spatial correlogram model, an object of class "SpatialCorrelogramModel".
}
\details{
For the spatial variables allowed autocorrelation functions are listed in Table 4.1 of the
gstat manual (\url{http://www.gstat.org/gstat.pdf}). Spatial correlation
assumes stationarity, i.e. correlation depends only on the separation
distance between points in space. Anisotropy is allowed (http://www.gstat.org/gstat.pdf). No nested
models are allowed in the current version.
}
\examples{

mycormodel <- makeCRM(acf0 = 0.8, range = 300, model = "Exp")
str(mycormodel)

}
\author{
Kasia Sawicka, Gerard Heuvelink
}
