% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions_application.R
\name{geo_weights}
\alias{geo_weights}
\title{Inverse Geographic Weight Matrix}
\usage{
geo_weights(coordinates, N_assignments)
}
\arguments{
\item{coordinates}{matrix of coordinates of observations.}

\item{N_assignments}{vector of neighborhood assignments.}
}
\value{
Returns a weighting matrix \code{W} and the coordinates of the centers per neighborhood \code{centersN}.
}
\description{
Calculates a inverse-distance based weight matrix for the function \code{\link[ssMRCD]{ssMRCD}} (see details).
}
\details{
First, the centers (means of the coordinates given) \eqn{c_i} of each neighborhood is calculated.
Then, the Euclidean distance between the centers is calculated and the weight is based on
the inverse distance between two neighborhoods, \deqn{w_{ij} = \frac{1}{dist(c_i, c_j)}. }
It is scaled according to a weight matrix.
}
\examples{
coordinates = matrix(rnorm(1000), ncol = 2, nrow = 500)
N_ass = sample(1:5, 500, replace = TRUE)

geo_weights(coordinates, N_ass)

}
\seealso{
\code{\link[ssMRCD]{rescale_weights}}
}
