% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcanz.R
\name{ssd_hc_bcanz}
\alias{ssd_hc_bcanz}
\title{BCANZ Hazard Concentrations}
\usage{
ssd_hc_bcanz(x, nboot = 10000, delta = 10, min_pboot = 0.9)
}
\arguments{
\item{x}{The object.}

\item{nboot}{A count of the number of bootstrap samples to use to estimate the se and confidence limits. A value of 10000 is recommended for official guidelines.}

\item{delta}{A non-negative number specifying the maximum absolute Akaike Information-theoretic Criterion difference cutoff. Distributions with an absolute difference from the best model greater than the cutoff are excluded.}

\item{min_pboot}{A number of the minimum proportion of bootstrap samples that must successfully fit
in the sense of returning a likelihood.}
}
\value{
A tibble of corresponding hazard concentrations.
}
\description{
Gets hazard concentrations with confidence intervals that protect
1, 5, 10 and 20\% of species using settings adopted by
BC, Canada, Australia and New Zealand for official guidelines.
This function can take several minutes to run with required 10,000 iterations.
}
\examples{
fits <- ssd_fit_bcanz(ssddata::ccme_boron)
ssd_hc_bcanz(fits, nboot = 100)
}
\seealso{
\code{\link[=ssd_hc]{ssd_hc()}}.

Other BCANZ: 
\code{\link{ssd_fit_bcanz}()}
}
\concept{BCANZ}
