% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Mroz87}
\alias{Mroz87}
\title{U.S. Women's Labor Force Participation}
\format{
An object of class \code{data.frame} with 753 rows and 22 columns.
}
\source{
PSID Staff, The Panel Study of Income Dynamics,
Institute for Social ResearchPanel Study of Income
Dynamics, University of Michigan, \url{https://psidonline.isr.umich.edu/}
}
\usage{
Mroz87
}
\description{
The Mroz87 data frame contains data about 753
married women. These data are collected within the
"Panel Study of Income Dynamics" (PSID). Of the 753
observations, the first 428 are for women with positive
hours worked in 1975, while the remaining 325
observations are for women who did not work for
pay in 1975. A more complete discussion of the data
is found in \insertCite{mroz1987;textual}{ssmodels}. It also
includes the following explanatory variables:
\itemize{
  \item{lfp: Dummy variable for labor-force participation.}
  \item{hours: Wife's hours of work in 1975. }
  \item{kids5: Number of children 5 years old or younger.}
  \item{kids618: Number of children 6 to 18 years old.}
  \item{Age: Wife's age.}
  \item{Educ: Wife's educational attainment, in years.}
  \item{wage: Wife's average hourly earnings, in 1975 dollars.}
  \item{repwage: Wife's wage reported at the time of the 1976 interview.}
  \item{hushrs: Husband's hours worked in 1975.}
  \item{husage: Husband's age.}
  \item{huseduc: Husband's educational attainment, in years.}
  \item{huswage: Husband's wage, in 1975 dollars.}
  \item{faminc: Family income, in 1975 dollars.}
  \item{mtr: Marginal tax rate facing the wife.}
  \item{motheduc: Wife's mother's educational attainment, in years.}
  \item{fatheduc: Wife's father's educational attainment, in years.}
  \item{unem: Unemployment rate in county of residence, in percentage points.}
  \item{city: Dummy variable = 1 if live in large city, else 0. }
  \item{exper: Actual years of wife's previous labor market experience.}
  \item{nwifeinc: Non-wife income.}
  \item{wifecoll: Dummy variable for wife's college attendance.}
  \item{huscoll: Dummy variable for husband's college attendance.}
}
}
\examples{
# Wooldridge(2016): page 247
data(Mroz87)
attach(Mroz87)
selectEq  <- lfp ~ nwifeinc + educ + exper + I(exper^2) + age + kids5 + kids618
outcomeEq <- log(wage) ~ educ + exper + I(exper^2)
outcomeS  <- cbind(educ, exper)
outcomeC  <- cbind(educ, exper)
outcomeBS <- wage ~ educ + exper + I(exper^2)
outcomeBS <- wage ~ educ + exper + I(exper^2)
HeckmanCL(selectEq, outcomeEq, data = Mroz87)
HeckmanBS(selectEq, outcomeBS, data = Mroz87)
HeckmanSK(selectEq, outcomeEq, data = Mroz87, lambda = 1)
HeckmantS(selectEq, outcomeEq, data = Mroz87, df=5)
HeckmanGe(selectEq, outcomeEq, outcomeS, outcomeC, data = Mroz87)

}
\references{
{
  \insertRef{mroz1987}{ssmodels}

  \insertRef{ssmrob}{ssmodels}

  \insertRef{sampleSelection}{ssmodels}

  \insertRef{wooldridge2016}{ssmodels}
}
}
\keyword{datasets}
