% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifeRisk-simulation.R
\name{compute.lifeRisk}
\alias{compute.lifeRisk}
\title{Compute a LifeRisk}
\usage{
\method{compute}{lifeRisk}(object, market.risk, life.item, nsim, seed = NULL,
  ...)
}
\arguments{
\item{object}{S3 object of class lifeRisk.}

\item{market.risk}{S3 object of class marketRisk created using the constructor
\code{marketRisk}.}

\item{life.item}{S3 object of class life from a portfolio.}

\item{nsim}{strictly positive integer value of length one. The number
of simulations.}

\item{seed}{positive integer value of length one. The seed for
reproducibility.}

\item{...}{additional arguments.}
}
\value{
a \code{data.table} value containing one column named \code{"lifeRisk"}. The
  simulations result for a lifeRisk.
}
\description{
\code{compute} is a generic S3 method for classes inheriting from risk.
  It returns a vector of aggregated simulations for the corresponding risk.
}
\seealso{
\code{\link{compute}}, \code{\link{lifeRisk}}.
}
