% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profileLogliks.R
\name{profile_logliks}
\alias{profile_logliks}
\title{Plot profile log-likelihood functions about the estimates}
\usage{
profile_logliks(
  stvar,
  which_pars,
  scale = 0.1,
  nrows,
  ncols,
  precision = 50,
  stab_tol = 0.001,
  posdef_tol = 1e-08,
  distpar_tol = 1e-08,
  weightpar_tol = 1e-08
)
}
\arguments{
\item{stvar}{an object of class \code{'stvar'}, created by, e.g., \code{fitSTVAR} or \code{fitSSTVAR}.}

\item{which_pars}{the profile log-likelihood function of which parameters should be plotted? An integer
vector specifying the positions of the parameters in the parameter vector. The parameter vector has the
form...}

\item{scale}{a numeric scalar specifying the interval plotted for each estimate:
the estimate plus-minus \code{abs(scale*estimate)}.}

\item{nrows}{how many rows should be in the plot-matrix? The default is \code{max(ceiling(log2(length(which_pars)) - 1), 1)}.}

\item{ncols}{how many columns should be in the plot-matrix? The default is \code{ceiling(length(which_pars)/nrows)}.
Note that \code{nrows*ncols} should not be smaller than the length of \code{which_pars}.}

\item{precision}{at how many points should each profile log-likelihood function be evaluated at?}

\item{stab_tol}{numerical tolerance for stability of condition of the regimes: if the "bold A" matrix of any regime
has eigenvalues larger that \code{1 - stat_tol} the parameter is considered to be outside the parameter space.
Note that if tolerance is too small, numerical evaluation of the log-likelihood might fail and cause error.}

\item{posdef_tol}{numerical tolerance for positive definiteness of the error term covariance matrices: if
the error term covariance matrix of any regime has eigenvalues smaller than this, the parameter is considered
to be outside the parameter space. Note that if the tolerance is too small, numerical evaluation of the
log-likelihood might fail and cause error.}

\item{distpar_tol}{the parameter vector is considered to be outside the parameter space if the degrees of
freedom parameters is not larger than \code{2 + distpar_tol} (applies only if \code{cond_dist="Student"}).}

\item{weightpar_tol}{numerical tolerance for weight parameters being in the parameter space. Values closer to
to the border of the parameter space than this are considered to be "outside" the parameter space.}
}
\value{
Only plots to a graphical device and doesn't return anything.
}
\description{
\code{profile_logliks} plots profile log-likelihood functions about the estimates.
}
\details{
When the number of parameters is large, it might be better to plot a smaller number of profile
 log-likelihood functions at a time using the argument \code{which_pars}.

The red vertical line points the estimate.
}
\examples{
# Threshold STVAR with p=1, M=2, the first lag of the second variable as switching variable:
pars <- c(0.5231, 0.1015, 1.9471, 0.3253, 0.3476, 0.0649, -0.035, 0.7513, 0.1651,
 -0.029, -0.7947, 0.7925, 0.4233, 5e-04, 0.0439, 1.2332, -0.0402, 0.1481, 1.2036)
mod12thres <- STVAR(data=gdpdef, p=1, M=2, params=pars, weight_function="threshold",
  weightfun_pars=c(2, 1))

# Plot the profile log-likelihood functions of all parameters:
profile_logliks(mod12thres, precision=50) # Plots fast with precision=50

# Plot only the profile log-likelihood function of the threshold parameter
# (which is the last parameter in the parameter vector):
profile_logliks(mod12thres, which_pars=length(pars), precision=100)

# Plot only the profile log-likelihood functions of the intercept parameters
# (which are the first four parameters in the parameter vector, as d=2 and M=2):
profile_logliks(mod12thres, which_pars=1:4, precision=100)
}
\references{
\itemize{
   \item Anderson H., Vahid F. 1998. Testing multiple equation systems for common nonlinear components.
     \emph{Journal of Econometrics}, \strong{84}:1, 1-36.
   \item Hansen B.E. 1994. Autoregressive Conditional Density estimation.
     \emph{Journal of Econometrics}, \strong{35}:3, 705-730.
   \item Kheifets I.L., Saikkonen P.J. 2020. Stationarity and ergodicity of Vector STAR models.
     \emph{International Economic Review}, \strong{35}:3, 407-414.
   \item Lanne M., Virolainen S. 2024. A Gaussian smooth transition vector autoregressive model:
      An application to the macroeconomic effects of severe weather shocks. Unpublished working
      paper, available as arXiv:2403.14216.
   \item Lütkepohl H. 2005. New Introduction to Multiple Time Series Analysis,
         \emph{Springer}.
   \item McElroy T. 2017. Computation of vector ARMA autocovariances.
         \emph{Statistics and Probability Letters}, \strong{124}, 92-96.
   \item Kilian L., Lütkepohl H. 20017. Structural Vector Autoregressive Analysis. 1st edition.
     \emph{Cambridge University Press}, Cambridge.
   \item Tsay R. 1998. Testing and Modeling Multivariate Threshold Models.
     \emph{Journal of the American Statistical Association}, \strong{93}:443, 1188-1202.
   \item Virolainen S. 2024. Identification by non-Gaussianity in structural threshold and
      smooth transition vector autoregressive models. Unpublished working
      paper, available as arXiv:2404.19707.
 }
}
\seealso{
\code{\link{get_foc}}, \code{\link{get_soc}}, \code{\link{diagnostic_plot}}
}
